<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\Message;


class Common extends Base
{

    public function _initialize(){
        parent::_initialize();
    }

    public function saveSql() {
        
        $framework = $this->param("fk/d");

        //保存路径，默认为站点根目录下的data文件夹里
        $path = ROOT_PATH ."public/";    
        //获取数据库名
        $dbname=config("database.database");    
        //检查目录是否存在  
        if(!is_dir($path)) { 
            //新建目录  
            // mkdir($path, 0777, true);
        }
        //检查目录是否可写  
        if(!is_writable($path)) {
            chmod($path,0777);
        }
        //检查文件是否存在
        $fileName = date("YmdHis").'.sql';
        if($framework == 1) {
            $fileName = 'data.sql';
        }
        //数据库保存相对路径
        $filePath = "public/".$fileName;
        //硬盘保存绝对路径
        $savepath = $path.$fileName;

        $data_table = ['fa_admin','fa_auth_group','fa_auth_group_access','fa_auth_rule','fa_bbfx','fa_bbfx_auth','fa_category','fa_config','fa_platform'];
        
        try{
            //获取mysql版本
            $version = Db::query("select version() as ver");
            $ver = $version[0]['ver'];
            $info = "-- ----------------------------\r\n";
            $info .= "-- 日期：".date("Y-m-d H:i:s",time())."\r\n";
            $info .= "-- MySQL - ".$ver." : Database - ".$dbname."\r\n";
            $info .= "-- ----------------------------\r\n\r\n";
            // $info .= "CREATE DATAbase IF NOT EXISTS `".$dbname."` DEFAULT CHARACTER SET utf8 ;\r\n\r\n";
            // $info .= "USE `".$dbname."`;\r\n\r\n";
            file_put_contents($savepath,$info);
            //查询所有表  
            $sql="show tables";
            //执行原生SQL语句
            $result=Db::query($sql);            
            foreach ($result as $k=>$v) {
                //查询表结构  
                $table = $v['Tables_in_'.$dbname];
                $sql_table = "show create table ".$table;
                $res = Db::query($sql_table);             
                $info_table = "-- ----------------------------\r\n";
                $info_table .= "-- Table structure for `".$table."`\r\n";
                $info_table .= "-- ----------------------------\r\n\r\n";
                $info_table .= "DROP TABLE IF EXISTS `".$table."`;\r\n\r\n";
                $info_table .= $res[0]['Create Table'].";\r\n\r\n";

                if($framework == 1 && !in_array($table,$data_table)) {
                    file_put_contents($savepath,$info_table,FILE_APPEND);
                }
                else{ 
                    //查询表数据  
                    $info_table .= "-- ----------------------------\r\n";
                    $info_table .= "-- Data for the table `".$table."`\r\n";
                    $info_table .= "-- ----------------------------\r\n\r\n";
                    file_put_contents($savepath,$info_table,FILE_APPEND);
                    $sql_data = "select * from ".$table;
                    $data = Db::query($sql_data);
                    $count= count($data); 
                    if($count<1) continue;
                    foreach ($data as $key => $value) {
                        if($framework == 1) {
                            if($table == "fa_config") {
                                if($value['name'] == 'logo'){
                                    $value["value"] = "/assets/images/logo.png";
                                }
                                if($value['name'] == 'login_bg'){
                                    $value["value"] = "/assets/images/login-bg.jpg"; 
                                }
                            }   
                            if($table == "fa_platform") {
                                $value["AppId"] = "";
                                $value["AppSecret"] = "";
                                $value["mch_id"] = "";
                                $value["paykey"] = "";
                                $value["cert"] = "";
                                $value["certkey"] = "";
                                $value["wxapp_AppId"] = "";
                                $value["wxapp_AppSecret"] = "";
                                $value["wxapp_mch_id"] = "";
                                $value["wxapp_paykey"] = "";
                                $value["wxapp_cert"] = "";
                                $value["wxapp_certkey"] = "";
                                $value["service_provider_status"] = 0;
                                $value["service_provider_appid"] = "";
                                $value["service_provider_mchid"] = "";
                                $value["service_provider_paykey"] = "";
                                $value["service_provider_cert"] = "";
                                $value["service_provider_certkey"] = "";
                                $value["zfb_appid"] = "";
                                $value["zfb_publickey_cert"] = "";
                                $value["zfb_root_cert"] = "";
                                $value["zfb_app_cert"] = "";
                                $value["zfb_privateKey"] = "";
                                $value["wap_AppId"] = "";
                                $value["wap_AppSecret"] = "";
                                $value["wap_mch_id"] = "";
                                $value["wap_paykey"] = "";
                                $value["wap_cert"] = "";
                                $value["wap_certkey"] = "";
                                $value["access_token"] = "";
                                $value["access_token_appid"] = "";
                                $value["wxapp_access_token"] = "";
                                $value["wxapp_access_token_appid"] = "";
                                $value["ticket"] = "";
                                $value["ticket_appid"] = "";
                            }
                        }
                        
                        $sqlStr = "INSERT INTO `{$table}` VALUES (";
                        foreach($value as $kk => $column) {
                            
                            //当值为空时，使用default默认
                            // $sqlStr .=empty($column) ? "default, " : "'".$column."', ";
                            if(is_string($column)) {
                                //对单引号和换行符进行一下转义
                                $column = str_replace( array("'","\r\n"), array("\'","\\r\\n"),$column);
                                $sqlStr .= "'".$column."', ";
                            }
                            else if(is_null($column)) {
                                $sqlStr .= "NULL, ";
                            }
                            else{
                                $sqlStr .= $column.", ";
                            }
                        }
                        //去掉最后一个逗号和空格  
                        $sqlStr = substr($sqlStr,0,strlen($sqlStr)-2);
                        $sqlStr .= ");\r\n";
                        //$sqlStr = "INSERT INTO `{$table}` VALUES ('" . str_replace(array("\r", "\n"), array('\\r', '\\n'), implode("', '", $value)) . "');\n";
                        file_put_contents($savepath,$sqlStr,FILE_APPEND);
                    }
                    $info = "\r\n";
                    file_put_contents($savepath,$info,FILE_APPEND);
                }
                
            }
            $result = __json(1,"操作成功");
        } catch (\Exception $e) {
            $result = __json(0,$e->getMessage());
        }
        if($framework == 1) {
            __result($result);
        }
        return $result;
    }
    
    public function clearData(){
        $uniacid = UNIACID;
        $type = $this->param("type/d");
        $title = "清除数据";
        
        $where = ['uniacid'=>$uniacid,'id'=>['>',0]];


        $result = $this->saveSql();

        // __result($result);
        
        
        if($type == 1){
            $content = "清除用户数据";
        }
        else{
            $content = "清除所有数据";
            
            Db::name("admin_log")->where($where)->delete();
            Db::name("bbfx_agent")->where($where)->delete();
            Db::name("bbfx_apopup")->where($where)->delete();
            Db::name("bbfx_apopup_set")->where($where)->delete();
            // Db::name("bbfx_attachment_category")->where($where)->delete();
            Db::name("bbfx_base")->where($where)->delete();
            Db::name("bbfx_category")->where($where)->delete();
            Db::name("bbfx_cloud_warehouse")->where($where)->delete();
            Db::name("bbfx_contract")->where($where)->delete();
            Db::name("bbfx_contract_set")->where($where)->delete();
            Db::name("bbfx_cumulative_fanhuan")->where($where)->delete();
            Db::name("bbfx_directpush_team")->where($where)->delete();
            Db::name("bbfx_diypage")->where($where)->delete();
            Db::name("bbfx_double_track")->where($where)->delete();
            Db::name("bbfx_double_track_level")->where($where)->delete();
            Db::name("bbfx_dynamic_redpacket")->where($where)->delete();
            // Db::name("bbfx_express")->where($where)->delete(); // 统一物流公司
            Db::name("bbfx_fenxiao")->where($where)->delete();
            Db::name("bbfx_fenxiao_abonus_rule")->where($where)->delete();
            Db::name("bbfx_fenxiao_level")->where($where)->delete();
            Db::name("bbfx_goods")->where($where)->delete();
            Db::name("bbfx_goods_category")->where($where)->delete();
            Db::name("bbfx_goods_spec")->where($where)->delete();
            Db::name("bbfx_goods_spec_item")->where($where)->delete();
            Db::name("bbfx_goods_spec_sku")->where($where)->delete();
            Db::name("bbfx_member_card")->where($where)->delete();
            Db::name("bbfx_news_article")->where($where)->delete();
            Db::name("bbfx_news_category")->where($where)->delete();
            Db::name("bbfx_news_video")->where($where)->delete();
            // Db::name("bbfx_plugin")->where($where)->delete();
            Db::name("bbfx_printer")->where($where)->delete();
            Db::name("bbfx_queue_mode")->where($where)->delete();
            Db::name("bbfx_return")->where($where)->delete();
            Db::name("bbfx_return_rule")->where($where)->delete();
            // Db::name("bbfx_role")->where($where)->delete();
            Db::name("bbfx_sabonus")->where($where)->delete();
            Db::name("bbfx_scoreshop")->where($where)->delete();
            Db::name("bbfx_scoreshop_category")->where($where)->delete();
            Db::name("bbfx_scoreshop_goods")->where($where)->delete();
            Db::name("bbfx_scoreshop_goods_category")->where($where)->delete();
            Db::name("bbfx_seckill_activity")->where($where)->delete();
            Db::name("bbfx_seckill_goods")->where($where)->delete();
            Db::name("bbfx_serial_number")->where($where)->delete();
            Db::name("bbfx_short_video")->where($where)->delete();
            Db::name("bbfx_short_video_list")->where($where)->delete();
            Db::name("bbfx_store")->where($where)->delete();
            Db::name("bbfx_store_goods")->where($where)->delete();
            Db::name("bbfx_transfer_account")->where($where)->delete();
            Db::name("bbfx_coupon")->where($where)->delete();
            Db::name("bbfx_fenxiao_poster")->where($where)->delete();
            Db::name("bbfx_scoreshop_serial_number")->where($where)->delete();
            Db::name("bbfx_problem")->where($where)->delete();
            Db::name("bbfx_deposit_release")->where($where)->delete();
            Db::name("bbfx_scoreshop_store_goods")->where($where)->delete();
            Db::name("bbfx_chaoyue")->where($where)->delete();
            Db::name("bbfx_sinterest")->where($where)->delete();
            Db::name("bbfx_signin")->where($where)->delete();
            Db::name("bbfx_pintuan_goods")->where($where)->delete();
            Db::name("bbfx_pintuan")->where($where)->delete();
            Db::name("bbfx_ladderpingji")->where($where)->delete();
            Db::name("bbfx_merchant_set")->where($where)->delete();
            Db::name("bbfx_crazy")->where($where)->delete();
            Db::name("bbfx_sconnection")->where($where)->delete();
            Db::name("bbfx_rebate_pintuan")->where($where)->delete();
            Db::name("bbfx_npingji")->where($where)->delete();
            Db::name("bbfx_txabonus")->where($where)->delete();
            Db::name("bbfx_shippingfee_template")->where($where)->delete();
            Db::name("bbfx_capitalpool")->where($where)->delete();
            Db::name("bbfx_capitalpool_money_log")->where($where)->delete();
            Db::name("bbfx_paihangbang")->where($where)->delete();
            Db::name("bbfx_super_maihuo")->where($where)->delete();
            Db::name("bbfx_pyramid")->where($where)->delete();
            Db::name("bbfx_goods_stock_log")->where($where)->delete();
            Db::name("bbfx_sverify")->where($where)->delete();
            Db::name("bbfx_sverify_product")->where($where)->delete();
            Db::name("bbfx_sverify_product_code")->where($where)->delete();
            Db::name("bbfx_sverify_product_query_log")->where($where)->delete();
            Db::name("bbfx_laddermanage")->where($where)->delete();
            Db::name("bbfx_yajin")->where($where)->delete();
            Db::name("bbfx_smaterial")->where($where)->delete();
            Db::name("bbfx_smaterial_category")->where($where)->delete();
            Db::name("bbfx_smaterial_item")->where($where)->delete();
            Db::name("bbfx_qwen")->where($where)->delete();
            Db::name("bbfx_shuziren")->where($where)->delete();
            Db::name("bbfx_contribution")->where($where)->delete();
            Db::name("bbfx_import_log")->where($where)->delete();
            Db::name("bbfx_import_gift")->where($where)->delete();
            
        }
        
        Db::name("bbfx_user")->where($where)->delete();
        Db::name("user")->where(['id'=>['>',0]])->delete();
        Db::name("bbfx_agent_log")->where($where)->delete();
        Db::name("bbfx_apopup_log")->where($where)->delete();
        Db::name("bbfx_cloud_warehouse_goods")->where($where)->delete();
        Db::name("bbfx_cloud_warehouse_stock_record")->where($where)->delete();
        Db::name("bbfx_contract_record")->where($where)->delete();
        Db::name("bbfx_cumulative_fanhuan_user")->where($where)->delete();
        Db::name("bbfx_dynamic_redpacket_sequence")->where($where)->delete();// 用户统计无user_id
        Db::name("bbfx_dynamic_redpacket_sequence_item")->where($where)->delete();
        Db::name("bbfx_feedback")->where($where)->delete();
        Db::name("bbfx_fenxiao_abonus_item")->where($where)->delete();
        Db::name("bbfx_fenxiao_apply")->where($where)->delete();
        Db::name("bbfx_fenxiao_commission")->where($where)->delete();
        Db::name("bbfx_fenxiao_order")->where($where)->delete();
        Db::name("bbfx_fenxiao_upgrade_record")->where($where)->delete();
        Db::name("bbfx_member_card_order")->where($where)->delete();
        Db::name("bbfx_money_log")->where($where)->delete();
        Db::name("bbfx_order")->where($where)->delete();
        Db::name("bbfx_order_goods")->where($where)->delete();
        Db::name("bbfx_order_hexiao_record")->where($where)->delete();
        Db::name("bbfx_order_refund")->where($where)->delete();
        Db::name("bbfx_pay_order")->where($where)->delete();// 无user_id
        Db::name("bbfx_queue_mode_user")->where($where)->delete();
        Db::name("bbfx_queue_mode_user_record")->where($where)->delete();// 无user_id
        Db::name("bbfx_recharge_order")->where($where)->delete();
        Db::name("bbfx_return_item")->where($where)->delete();
        Db::name("bbfx_return_log")->where($where)->delete();
        Db::name("bbfx_sabonus_part")->where($where)->delete();
        Db::name("bbfx_scoreshop_order")->where($where)->delete();
        Db::name("bbfx_scoreshop_order_goods")->where($where)->delete();
        Db::name("bbfx_scoreshop_order_refund")->where($where)->delete();
        Db::name("bbfx_short_video_comment")->where($where)->delete();
        Db::name("bbfx_short_video_collect")->where($where)->delete();
        Db::name("bbfx_short_video_comment_dianzan")->where($where)->delete();
        Db::name("bbfx_short_video_share")->where($where)->delete();
        Db::name("bbfx_transfer_account_log")->where($where)->delete();// 无user_id
        Db::name("bbfx_user_address")->where($where)->delete();
        Db::name("bbfx_user_cart")->where($where)->delete();
        Db::name("bbfx_user_coupon")->where($where)->delete();
        Db::name("bbfx_verifcode")->where($where)->delete();// 无user_id
        Db::name("bbfx_withdrawal_log")->where($where)->delete();
        Db::name("bbfx_store_reservation")->where($where)->delete();
        Db::name("bbfx_deposit_release_order")->where($where)->delete();
        Db::name("bbfx_goods_comment")->where($where)->delete();
        Db::name("bbfx_scoreshop_order_hexiao_record")->where($where)->delete();
        Db::name("bbfx_signin_record")->where($where)->delete();
        Db::name("bbfx_pintuan_order")->where($where)->delete();
        Db::name("bbfx_comment_zan")->where($where)->delete();
        Db::name("bbfx_merchant")->where($where)->delete();
        Db::name("bbfx_merchant_money_log")->where($where)->delete();
        Db::name("bbfx_crazy_group")->where($where)->delete();
        Db::name("bbfx_crazy_group_user")->where($where)->delete();
        Db::name("bbfx_crazy_user")->where($where)->delete();
        Db::name("bbfx_sconnection_upgrade_log")->where($where)->delete();
        Db::name("bbfx_notice")->where($where)->delete();
        Db::name("bbfx_notice_log")->where($where)->delete();
        Db::name("bbfx_sconnection_upgrade_order")->where($where)->delete();
        Db::name("bbfx_txabonus_log")->where($where)->delete();
        Db::name("bbfx_txabonus_user")->where($where)->delete();
        Db::name("bbfx_super_maihuo_group")->where($where)->delete();
        Db::name("bbfx_super_maihuo_group_user")->where($where)->delete();
        Db::name("bbfx_super_maihuo_user")->where($where)->delete();
        Db::name("bbfx_yajin_record")->where($where)->delete();
        Db::name("bbfx_yajin_refund_record")->where($where)->delete();
        Db::name("bbfx_qwen_chat")->where($where)->delete();
        Db::name("bbfx_shuziren_video")->where($where)->delete();
        Db::name("bbfx_shuziren_video_tpl")->where($where)->delete();
        Db::name("bbfx_shuziren_voice")->where($where)->delete();
        
        \app\admin\model\AdminLog::record($title,$content);
        
        __success("操作成功");
    }
    
    public function sendUpdateNotice(){
        global $_W;
        $params = $this->param();
        $set = $_W['base'];
        
        if($set['updatenotice_status'] != 1){
            __error("请先开启主动通知");
        }
        
        $subscribemsg = $set['subscribemsg'];
        if(empty($subscribemsg)){
            __error("请先设置通知消息");
        }
        
        if(empty($subscribemsg['updatenotice_tid']['tid']) || empty($subscribemsg['updatenotice_tid']['content'])){
            __error("请先设置通知消息");
        }
        
        echo json_encode(__json(1,"发送成功！"));
        
        if(function_exists("fastcgi_finish_request")){
            ob_flush();
            flush();
            fastcgi_finish_request();
        }
        
        $list = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'update_notice'=>['>',0]])->field(['id','openid'])->select();
        // file_put_contents("message111.txt",json_encode($list));
        if(!empty($list)){
            foreach ($list as $key => $val){
                try {
                    Db::name("bbfx_user")->where(['id'=>$val['id']])->setDec("update_notice",1);
                } 
                catch (\Exception $e) {
                    
                }
                $result = Message::sendUpdatenoticeMsg($val,$set);
                // file_put_contents("message222.txt",json_encode($result));
            }   
        }
    }
    
    public function selWxappTemplate(){
        $params = $this->param();
        
        $template_id = trim($params['template_id']);
	        
        $templateList = Message::getWxappTemplateList();
        //iUf2rl98Geg1DJQan9soxC_H8cyGibKL5QTTOgyc2fk
        if(empty($templateList)){
            __error("未查询到模板，请登录微信开发平台添加模板");
        }
        else{
            $template_content = [];
            $template_title = "";
            foreach ($templateList as $key => $val){
                if($val['priTmplId'] == $template_id){
                    $template_title = $val['title'];
                    $template_content = $val['content'];
                    break;
                }
            }
            
            if(empty($template_content)){
                __error("未查询到模板，请登录微信开发平台添加模板");
            }
            
            
            $template_content = explode("\n",$template_content);
            
            $template_data = [];
            foreach ($template_content as $key => $val){
                $data = explode(":",$val);
                if(!empty($data[1])){
                    $keys = str_replace("{{","",$data[1]);
                    $keys = str_replace(".DATA}}","",$keys);
                    
                    $title = $data[0];
                    if(empty($title)){
                        $title = "";
                    }
                    
                    $template_data[] = array("key"=>$keys,"val"=>"","title"=>$title);
                }
                
            }
            
            // echo "<pre>";
            // print_r($template_data);die;
            __success("操作成功",$template_data);
        }
    }
    
    public function selTemplate(){
        $params = $this->param();
        
        $template_id = trim($params['template_id']);
    
        $appid = trim($params['wx_appid']);
        $secret = trim($params['wx_secret']);
    	        
        $templateList = Message::getTemplateList($appid,$secret);
        if(empty($templateList)){
            __error("未查询到模板，请登录微信公众平台添加模板");
        }
        else{
            $template_content = [];
            $template_title = "";
            foreach ($templateList as $key => $val){
                if($val['template_id'] == $template_id){
                    $template_title = $val['title'];
                    $template_content = $val['content'];
                    break;
                }
            }
            
            if(empty($template_content)){
                __error("未查询到模板，请登录微信开发平台添加模板");
            }
            
            
            $template_content = explode("\n",$template_content);
            
            $template_data = [];
            foreach ($template_content as $key => $val){
                $data = explode("：",$val);
                if(count($data) == 1){
                    $data = str_replace("{{","",$data[0]);
                    $data = str_replace(".DATA}}","",$data);
                    
                    if($key == 0){
                        $template_data[] = array("key"=>$data,"val"=>$template_title,"title"=>"");
                    }
                    else{
                        $template_data[] = array("key"=>$data,"val"=>"","title"=>"");
                    }
                }
                else{
                    $keys = str_replace("{{","",$data[1]);
                    $keys = str_replace(".DATA}}","",$keys);
                    
                    $template_data[] = array("key"=>$keys,"val"=>"","title"=>$data[0]);
                }
            }
            
           // echo "<pre>";
           // print_r($template_data);die;
            __success("操作成功",$template_data);
        }
    }
    
    public function search_goods(){
        $params = $this->param();
        
        $keywords = trim($params['keywords']);
    
        $where = array("uniacid"=>UNIACID,'mid'=>0);
        if($keywords){
            $where['title'] = ['like',"%".$keywords."%"];
        }
        
        $goods = Db::name("bbfx_goods")->where($where)->order('sort desc')->select();
        
        if($goods){
            
            foreach ($goods as &$val){
                $val['thumb'] = cdnurl($val['thumb']);
            } 
            __success("success",$goods);
        }
        else{
            __error("未查询到数据");
        }
    }
    
    public function getExpressList(){
        $list = Db::name("bbfx_express")->where(['status'=>1])->select();
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function delete(){
        $params = $this->param();
        
        $tab = trim($params['tab']);
        if(empty($tab)){
            __error("操作失败");
        }
        
        $tabs = ['goods','diypage','category','serial_number','article','fenxiao_level','scoreshop_category','scoreshop_goods','scoreshop_serial_number','printer'];
        if(!in_array($tab,$tabs)){
            __error("操作失败");
        }
        
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_".$tab)->where('id','in',$ids)->delete();
      	if($res){
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}