<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\contract;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Contract extends Base
{

    protected $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Contract;
    }
    

    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("uniacid"=>UNIACID);
        
        $list = Db::name("bbfx_contract")->where($where)->order('id desc')->limit(($pindex - 1) * $psize,$psize)->select();
        $total = Db::name("bbfx_contract")->where($where)->count();
        foreach($list as $key => &$val){
            $val['createtime'] = date('Y-m-d H:i:s',$val['createtime']);
        }
        unset($val);
        
        // $this->model->createUserGoodsContract(44);
        
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function getUserContractList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("uniacid"=>UNIACID);
        
        $list = Db::name("bbfx_contract_record")->where($where)->order('id desc')->limit(($pindex - 1) * $psize,$psize)->select();
        $total = Db::name("bbfx_contract_record")->where($where)->count();
        foreach($list as $key => &$val){
            $user = Db::name("bbfx_user")->where(['id'=>$val['user_id']])->field("id,nickname,avatar")->find();
            $user['avatar'] = cdnurl($user['avatar']); 
            $val['content'] = cdnurl($val['content']); 
            $val['user'] = $user;
            $val['createtime'] = date('Y-m-d H:i:s',$val['createtime']);
            if($val['status'] == 1){
                $val['signingtime'] = date('Y-m-d H:i:s',$val['signingtime']);
            }
        }
        unset($val);
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function detail(){
        $params = $this->param();
        
        $info = Db::name("bbfx_contract")->where("id",$params['id'])->find();
        
        if(empty($info)){
            __error("数据不存在");
        }
        
        
        __success('操作成功',$info);
    }
    
    public function post(){
        $params = $this->param();
        $data = array(
            "uniacid"=>UNIACID,
            "name"=>$params['name'],
            "type"=>intval($params['type']),
            "signing_type"=>intval($params['signing_type'])
        );
        
        if(empty($data['name'])){
            __error("请输入合同名称");
        }
        if(empty($params['content'])){
            __error("请上传合同");
        }
        
        $file = $this->request->file('contract');
        
        if(empty($params['id']) || !empty($file)){
            $info = $file->getInfo();
            $ext = strtolower(substr($info['name'], strrpos($info['name'], '.')));
            
            $savePath = ROOT_PATH . 'public/contract/';
            $res = $file->move($savePath,random(32).$ext);
            
            if($res){
                $url = "/contract/".$res->getSaveName();
                $data['content'] = $url;
            }
            else{
                __error("合同上传失败");
            }
        }
        
        if(!empty($params['id'])){
            $res = Db::name("bbfx_contract")->where("id",$params['id'])->update($data);
            $data['id'] = $params['id'];
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_contract")->insertGetId($data);
            $data['id'] = $res;
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_contract");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    protected function upload($fileinput) {
        global $_W;
        $path = ROOT_PATH . "contract";
        mkdir($path);
        $f = $fileinput . '_' . UNIACID . '.pem';
        $outfilename = $path . "/" . $f;
        $filename = $_FILES[$fileinput]['name'];
        $tmp_name = $_FILES[$fileinput]['tmp_name'];
        if (!empty($filename) && !empty($tmp_name)) {
            $ext = strtolower(substr($filename, strrpos($filename, '.')));
            if ($ext != '.doc' && $ext != '.docx') {
                $errinput = "合同文件格式错误";
                __error(0, $errinput . ',请重新上传!');
            }
            return file_get_contents($tmp_name);
        }
        return "";
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_store")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'name');
        
      	$res = Db::name("bbfx_contract")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_contract");
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}