<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\deposit_release;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\Order as OrderModel;


class User extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\DepositRelease;
    }
    
    public function getMoneyLog(){
        $params = $this->param();
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        
        $where = array("a.uniacid"=>UNIACID,'a.type'=>6);
        
        $keyword = trim($params['keyword']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        $type = max(1,intval($params['type']));
        if($keyword){
            
            if($type == 1){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['b.realname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['b.mobile'] = $keyword;
            }
            else if($type == 4){
                $where['b.id'] = intval($keyword);
            }
            
        }
        
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        }
        
        $whereTime = [];
        if($endTime){
            $endTime = strtotime($endTime." 23:59:59");
            $whereTime['a.createtime'] = ['<=',$endTime];
        }
        
        
        $list = Db::name("bbfx_money_log")->alias("a")->join("bbfx_user b","a.user_id = b.id")->where($where)->where($whereTime)->field('a.*,b.nickname,b.avatar,b.mobile')->order('a.createtime desc')->limit(($pindex-1)*$psize,$psize)->select();
    	foreach($list as $key=>&$val){
    	    if($val['item_type'] == 3){
    	        $info = iunserializer($val['info']);
    	        $val['remarks'] .= "-".$info['notes'];
    	    }
    	    $val['avatar'] = cdnurl($val['avatar']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    
    	}
    	unset($val);
    	
    	$total = Db::name("bbfx_money_log")->alias("a")->join("bbfx_user b","a.user_id = b.id")->where($where)->where($whereTime)->count();
    	
    	__success("操作成功",['total'=>$total,'list'=>$list]);
    }
}