<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\fenxiao;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\Order as OrderModel;


class Order extends Base
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Fenxiao;
    }
    
    
    public function list(){
        global $_W;
        $params = $this->param();
        
        $user_id = intval($params['user_id']);
        $type = intval($params['type']);
        $base = $_W['base'];
        $texts = $base['fenxiao']['texts'];
        
        $where = ['a.uniacid'=>UNIACID,'a.user_id'=>$user_id,'a.status'=>1];
        
        
        if($type){
            $where['a.type'] = $type;
        }
        else{
            $where['a.type'] = ['in',[1,2,3]];
        }
        
        $keyword = trim($params['keyword']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        
        if($keyword){
            $where['a.order_no'] = $keyword;
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime);
            $where['a.createtime'] = ['>=',$startTime];
        }
        
        if($endTime){
            $endTime = strtotime($endTime)+(24*60*60);
            $whereTime['a.createtime'] = ['>='.$endTime];
        }
        
        $list = Db::name("bbfx_fenxiao_order")->alias("a")->join("bbfx_order_goods b","a.og_id=b.id")->join("bbfx_user c","a.user_id=c.id")->join("bbfx_order d","a.order_id=d.id")->where($where)->where($whereTime)->field("a.*,b.goods_info,b.total,b.price,c.nickname,c.avatar,d.order_no,d.user_id as x_user_id")->order("a.id desc")->select();
        
        if(empty($list)){
            $list = [];
        }
        
        foreach ($list as &$val){
            $goods_info = iunserializer($val['goods_info']);
            $goods_info['thumb'] = cdnurl($goods_info['thumb']);
            $val['avatar'] = cdnurl($val['avatar']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $user = Db::name("bbfx_user")->where(['id'=>$val['x_user_id']])->field(['id','avatar','nickname'])->find();
	        if(!empty($user)){
	            $user['avatar'] = cdnurl($user['avatar']);
	            $val['xuser'] = $user;
	        }
	        
	        $val['typeText'] = $this->model->getTypeText($val['type'],$val['money_type']);
	        if($val['money_type'] == 2){
                $val['moneyText'] = "+".floatval($val['money']).$base['texts']['score_unit'];
            }
            else{
                $val['moneyText'] = "+".floatval($val['money']).$texts['yuan'];
            }
	        $val['goods_info'] = $goods_info;
	        
        }
        unset($val);
        
        __success("success",array("list"=>$list,"title"=>$title));
    }

    public function getTeamOrder(){
        $params = $this->param();
        $user_id = intval($params['user_id']);
        if($user_id <= 0){
            __success("操作成功",['list'=>[]]);
        }

        $alldown = $this->model->getAllDown($user_id);
        $uids = [];
        if(!empty($alldown['ids'])){
            $uids = $alldown['ids'];
        }
        $uids[] = $user_id;

        $where = ['o.uniacid'=>UNIACID,'o.status'=>['in',[1,2,3]],'o.refund_status'=>['in',[-1,0,2]],'o.user_id'=>['in',$uids]];

        $list = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","og.order_id=o.id","LEFT")->where($where)->field("sum(og.total) as total,sum(og.price) as price,og.goods_id,og.goods_info")->group("og.goods_id")->select();
        foreach($list as $key=>&$val){
            $goods = iunserializer($val["goods_info"]);
            unset($val["goods_info"]);
            $val['goods_name'] = $goods['title'];
        }
        unset($val);

        __success("操作成功",['list'=>$list]);
    }

    public function getTeamOrderList(){
        $params = $this->param();
        
        $user_id = intval($params['user_id']);
        if($user_id <= 0){
            __success("操作成功",['list'=>[],'total'=>0]);
        }

        $alldown = $this->model->getAllDown($user_id);
        $uids = [];
        if(!empty($alldown['ids'])){
            $uids = $alldown['ids'];
        }
        $uids[] = $user_id;

        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;

        $where = ['a.uniacid'=>UNIACID,'a.status'=>['in',[1,2,3]],'a.refund_status'=>['in',[-1,0,2]],'a.user_id'=>['in',$uids]];

        $keyword = trim($params['keyword']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        $status = intval($params['status']);
        $paytype = intval($params['paytype']);
        $export = intval($params['export']);
        $refund_status = intval($params['refund_status']);
        $type = intval($params['type']);
        $mid = intval($params['mid']);
        $sup_uid = intval($params['sup_uid']);
        if($status != -1){
            if($status == 4){
                 $where['a.status'] = ['>=',1];
                if($refund_status != -1){
                    $where['a.refund_status'] = $refund_status;
                }
                else{
                    $where['a.refund_status'] = ['neq',-1];
                }
            }
            else{
                $where['a.status'] = $status;
            }
        }
        
        if($keyword){
            if($type == 1){
                $where['a.order_no'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['a.delivery_username'] = ['like',"%".$keyword."%"];
            }
            // else if($type == 4){
            //     $where['a.user_id'] = intval($keyword);
            // }
            else if($type == 5){
                $where['a.goods_info'] = ['like','%'.$keyword.'%'];
            }
            else if($type == 6){
                $uids = \app\common\model\bbfxshop\User::getLevel1UserIds(intval($keyword));
                $where['a.user_id'] = ['in',$uids];
            }
            else if($type == 7){
                $where['a.express'] = ['like','%'.$keyword.'%'];
            }
            else if($type == 8){
                $where['a.delivery_mobile'] = $keyword;
            }
        }
        if($paytype > 0){
            $where['a.paytype'] = $paytype;
        }
        
        if($mid > 0){
            $where['a.mid'] = $mid;
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        } 
        
        if($endTime){
            $endTime = strtotime($endTime." 23:59:59");
            $whereTime['a.createtime'] = ['<=',$endTime];
        }

        $list = Db::name("bbfx_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->field('a.*,b.avatar,b.nickname')->order('a.createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
        foreach($list as $key => &$val){
    	    
    	    $val['merchant_name'] = Db::name("bbfx_merchant")->where(['id'=>$val['mid']])->value("name");
    	    if(empty($val['merchant_name'])){
    	        $val['merchant_name'] = "";
    	    }
    	    
    	    $val['avatar'] = cdnurl($val['avatar']);
            $order_goods = Db::name("bbfx_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$val['id']])->select();
    	    
    	    foreach ($order_goods as $k => &$v){
    	        $goods_info = iunserializer($v['goods_info']);
    	        $goods_info['thumb'] = cdnurl($goods_info['thumb']);
    	        $v['goods'] = $goods_info;
    	    }
    	    unset($v);
    	    $val['order_goods'] = $order_goods;
    	    $val['paytypeText'] = "";
    	    if($val['is_pay'] == 1){
    	        $val['pay_time'] = date("Y-m-d H:i:s",$val['pay_time']);
    	        $val['paytypeText'] = OrderModel::getOrderPaytype($val['paytype']);
    	        
    	    }
    	    else{
    	        $val['pay_time'] = "";
    	    }
    	    
    	    if($val['is_electronic_waybill_print'] == 1){
    	        $extend = iunserializer($val['extend']);
                $expressPrintTemplate = str_replace("kg "," ",$extend['express']['PrintTemplate']);
    	        $val['expressPrintTemplate'] = $expressPrintTemplate;
    	    }
    	     
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    
    	    $val['typeText'] = OrderModel::getOrderType($val['order_type']);
    	    $val['refund_statusText'] = OrderModel::getOrderRefundStatus($val['refund_status']);
    	    $val['statusText'] = OrderModel::getOrderStatus($val);
    	    
    	    $sup_user = Db::name('bbfx_user')->where(['id'=>$val['one_share']])->field("id,nickname,avatar")->find();
    	    if(!empty($sup_user)){
    	        $sup_user['avatar'] = cdnurl($sup_user['avatar']);
    	        $val['sup_user'] = $sup_user;
    	    }
    	    
    	    $order_commission = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>['>',0],'money_type'=>['in',[1,3]],'order_id'=>$val['id']])->sum("money");
    	    $order_profit = $val['price'] - $val['cost_price'] - $order_commission;
    	    if($val['delivery_method'] == 1 && $val['order_type'] == 2){
    	        $order_profit -= $val['express_fee'];
    	    }
    	    $val['order_profit'] = max(0,round($order_profit,2));
    	    
    	    
    	}
    	unset($val);
    	
      
        $total = Db::name("bbfx_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->count();
    	
    	__success("操作成功",['total'=>$total,'list'=>$list]);
    }
}