<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\fenxiao;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Withdrawal extends Base
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Fenxiao;
    }
    
    public function check(){
        global $_W;
        $params = $this->param();
        
        $id = intval($params['id']);
        $status = intval($params['status']);
        $remarks = $params['remarks'];
        $log = Db::name("bbfx_withdrawal_log")->where(["uniacid"=>UNIACID,"id"=>$id,'withdrawal_type'=>2])->find();
        if(empty($log)){
            __error("提现记录不存在"); 
        }
        
        if(!in_array($status,[1,2])){
            __error("提现状态错误");  
        }
        
        if($log['status'] != 0){
            __error("已审核");  
        }
        
        try {
            Db::startTrans();
            
            if(empty($remarks)){
                $remarks = "";
            }
            
            $res = Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update(["status"=>$status]);
            if($res){
                
                if($status == 1){
                    Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update(["paytime"=>time()]);
                    if($log['type'] == 1){
                        User::setUserMoney($log['user_id'],$log['realmoney'],1,9,"佣金提现",$log);
                    }
                    else if($log['type'] == 6){
                        User::setUserMoney($log['user_id'],$log['realmoney'],2,9,"佣金提现",$log);
                    }
                    else if($log['type'] == 2){
                        $user = User::getInfo($log['user_id']);
                        
                        $out_batch_no = $log['out_batch_no'];
                        if(empty($out_batch_no)){
                            $out_batch_no = date("YmdHis").random(8,true);
                            Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update(['out_batch_no'=>$out_batch_no]);
                        }
                        
                        if($_W['base']['is_merch_transfer_new'] == 1){
                            $res = \app\common\model\bbfxshop\Wxpay::newTransfer($user['openid'],$log['realmoney'],$out_batch_no,$log['realname'],"佣金提现",$user['platform']);
                            if($res['code'] != 1){
                                throw new \Exception($res['message']);
                            }
                            $data = [
                                'batch_id'=>$res['data']['transfer_bill_no']
                            ];
                            if(!empty($res['data']['package_info'])){
                                $data['package_info'] = $res['data']['package_info'];
                            }
                            $data['is_confirm'] = 0;
                        }
                        else{
                            $res = \app\common\model\bbfxshop\Wxpay::transfer($user['openid'],$log['realmoney'],$out_batch_no,$log['withdrawal_no'],$log['realname'],"佣金提现");
                            if(empty($res) || $res['code'] != 1){
                                throw new \Exception($res['message']);
                            }
                            $data = [
                                'batch_id'=>$res['data']['batch_id']
                            ];
                        }
                        Db::name("bbfx_withdrawal_log")->where(['out_batch_no'=>$out_batch_no,'uniacid'=>UNIACID])->update($data);
                    }
                    
                    \app\common\model\bbfxshop\Txabonus::tixianExtract($log['id']);
                }
                else{
                    Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update(['remarks'=>$remarks]);
                    $log['notes'] = $remarks;
                    $this->model->setUserCommission($log['user_id'],$log['money'],21,"拒绝提现",$log);
                }
                
            }
            else{
                throw new \Exception("操作失败");
            }
            
            Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
            __error(0,$e->getMessage());
        }
        
        \app\common\model\bbfxshop\Sms::sendWithdrawalResultNotice($log);
        \app\admin\model\AdminLog::record("","",['id'=>$log['id'],'status'=>$status],"bbfx_withdrawal_log");
        __success("操作成功"); 
        
    }
    
    public function list(){
        $params = $this->param();
        
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("a.uniacid"=>UNIACID,'a.withdrawal_type'=>2);
        
        $export = intval($params['export']);
        $status = $params['status'];
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        
        $keyword = trim($params['keyword']);
        
        $type = max(1,intval($params['type']));
        if(!empty($keyword)){
            
            if($type == 1){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['a.realname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['b.mobile'] = $keyword;
            }
            else if($type == 4){
                $where['a.user_id'] = intval($keyword);
            }
        }
         
        if($status != ''){
            $where['a.status'] = intval($status);
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        }
        
        if($endTime){
            $endTime = strtotime($endTime." 23:59:59");
            $whereTime['a.createtime'] = ['<=',$endTime];
        }
        
        if($export == 1){
            $psize = 999999;
        }
        
        $list = Db::name("bbfx_withdrawal_log")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->field('a.*,b.avatar,b.nickname')->order('a.createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
    	
    	foreach($list as &$val){
    	    $val['avatar'] = cdnurl($val['avatar']);
    	    $val['skqrcode'] = cdnurl($val['skqrcode']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    if($val['paytime']){
    	        $val['paytime'] = date("Y-m-d H:i:s",$val['paytime']);
    	    }
    	    else{
    	        $val['paytime'] = "";
    	    }
    	    
    	    if($export == 1){
    	        $status = "待审核";
    	        if($val['status'] == 1){
    	            $status = "已打款";
    	        }
    	        else if($val['status'] == 2){
    	            $status = "已驳回";
    	        }
    	        
    	        $info = "";
    	        if($val['type'] == 3){
    	            $info .= $val['realname'].PHP_EOL;
    	            $info .= $val['alipay'];
    	        }
    	        else if($val['type'] == 4){
    	            $info .= $val['bankname'].PHP_EOL;
    	            $info .= $val['realname'].PHP_EOL;
    	            $info .= $val['bankcard'];
    	        }
    	        
    	        $export_list[] = array(
    	            $val['id'],
    	            $val['nickname'],
    	            $val['user_id'],
    	            $val['money'],
    	            $val['realmoney'],
    	            $val['service_charge'],
    	            $status,
    	            $info,
    	            $val['paytime'],
    	            $val['createtime']
    	        );
    	    }
    	}
    	unset($val);
    	
    	if($export == 1){
    	    $headArr = ["ID","用户昵称","用户ID","提现金额","实际到账","手续费","状态","提现信息","审核时间","提现时间"];
    	    $result = \app\common\model\PhpOffice::excelExport("tx-".date("Y-m-d"),$headArr,$export_list);
    	}
      
    	$total = Db::name("bbfx_withdrawal_log")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->count();
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_withdrawal_log")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("","",['id'=>$ids],"bbfx_withdrawal_log");
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}