<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\merchant;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Comment extends Base
{

    public function _initialize(){
        parent::_initialize();
    }
    
    public function getList(){
        
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $status = intval($params['status']);
        $goods_id = intval($params['goods_id']);
        $where = ["uniacid"=>UNIACID];
        if($status == 1){
            $where['sh_status'] = 0;
        }
        else if($status == 2){
            $where['sh_status'] = 1;
        }
        else if($status == 3){
            $where['sh_status'] = 2;
        }
        if($goods_id > 0){
            $where['goods_id'] = $goods_id;
        }
        if(empty($params['keyword'])){
            $where['goods_name'] = ['like','%'.$params['keyword'].'%'];
        }
        
        $list = Db::name("bbfx_goods_comment")->where($where)->order('createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
    	$total = Db::name("bbfx_goods_comment")->where($where)->count();
    	foreach ($list as $key => &$val) {
    	    $val['images'] = cdnurls(iunserializer($val['images']));
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    $val['info'] = iunserializer($val['info']);
    	    $val['info']['thumb'] = cdnurl($val['info']['thumb']);
    	    $user = Db::name("bbfx_user")->where(['id'=>$val['user_id']])->field("id,nickname,avatar")->find();
    	    if(!empty($user)){
    	        $user['avatar'] = cdnurl($user['avatar']);
    	        $val['user'] = $user;
    	    }
    	}
    	unset($val);
      	
        __success('操作成功',['total'=>$total,'list'=>$list]);
    }
    
    public function shenhe(){
        $id = intval($this->param("id/d"));
        $status = intval($this->param("status/d"));
        
        $item = Db::name("bbfx_goods_comment")->where(['id'=>$id])->find();
        if(empty($item)){
            __error("评论不存在");
        }
        if($item['sh_status'] != 0){
            __error("已审核");
        }
        
        $res = Db::name("bbfx_goods_comment")->where(['id'=>$id])->update(["sh_status"=>$status]);
        if($res){
            Db::name("bbfx_goods_comment")->where(['id'=>$id])->update(["sh_time"=>time()]);
            __success("操作成功");
        }
        else{
            __error(0,"操作失败");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_goods_comment")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'title');
        
      	$res = Db::name("bbfx_goods_comment")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("删除商户商品评价","商品评价：".implode(",",$titles)."，商户商品评价ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}