<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\merchant;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\Fenxiao;
use app\common\model\bbfxshop\Goods as GoodsModel;

class Goods extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Merchant;
    }
    
    public function shenhe(){
        $id = $this->param("id/d");
        $status = $this->param("status/d");
        $info = Db::name("bbfx_goods")->where(["id"=>$id])->find();
        if(empty($info)){
            __error("商品不存在");
        }
        
        if($status != 1) $status = 2;
        
        $res = Db::name("bbfx_goods")->where(["id"=>$info['id']])->update(['sh_status'=>$status]);
        if($res){
            Db::name("bbfx_goods")->where(["id"=>$info['id']])->update(['sh_time'=>time()]);
            \app\admin\model\AdminLog::record("","",['id'=>$info['id'],'sh_status'=>$status,'sh_time'=>time()],"bbfx_goods");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function status(){
        $params = $this->param();
        
        $ids = trim($params['id']);
        $status = intval($params['status']);
        
        if($status != 1){
            $status = 0;
        }
        
        if(empty($ids)){
            __error("请选择需要操作的商品");
        }
        
        $ids = explode(",",$ids);
        foreach ($ids as $k => &$v){
            $v = intval($v);
        }
        unset($v);
        
        $res = Db::name("bbfx_goods")->where(["id"=>['in',$ids]])->update(["status"=>$status]);
        if($res){
            
            $data = ['id'=>implode(",",$ids),'status'=>$status];
            
            \app\admin\model\AdminLog::record("","",$data,"bbfx_goods");
            
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function getList(){
        
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        
        $where = ["uniacid"=>UNIACID,"mid"=>['>',0]];
        
        $keyword = trim($params['keyword']);
        $category_id = intval($params['category_id']);
        $status = intval($params['status']);
        $mid = intval($params['mid']);
        $sh_status = intval($params['sh_status']);
        if($keyword){
            $where['title'] = ['like','%'.$keyword.'%'];
        }
        
        if($category_id){
            
            $goods_category = Db::name("bbfx_goods_category")->where("category_id",$category_id)->select();
            $goods_ids = array_column($goods_category,"goods_id");
            $where['id'] = ['in',$goods_ids];
        }
        
        if($status == 1){
            $where['status'] = 1;
        }
        else if($status == 2){
            $where['status'] = 0;
        }
        
        if($sh_status == 1){
            $where['sh_status'] = ['in',[1,2]];
        }
        else if($sh_status == 2){
            $where['sh_status'] = 0;
        }
        
        if($mid > 0){
            $where['mid'] = $mid;
        }
        
    	$list = Db::name("bbfx_goods")->where($where)->order('sort desc')->limit(($pindex - 1) * $psize,$psize)->select();
      	foreach($list as $key => &$val){
      	    
      	    $val['merchant_name'] = Db::name("bbfx_merchant")->where(['id'=>$val['mid']])->value("name");
      	    
      	    
      	    $slides = cdnurls(iunserializer($val['slides']));
      	    
      	    $val['slides'] = $slides;
        	$val['thumb'] = cdnurl($val['thumb']);
        	$val['share_img'] = cdnurl($val['share_img']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        	
            $categorys = Db::name("bbfx_goods_category")->alias("a")->join("bbfx_category b","a.category_id=b.id")->where(['a.uniacid'=>UNIACID,'a.goods_id'=>$val['id']])->field('b.id,b.title')->order('b.sort desc')->select();
        	
        	$val['categorys'] = $categorys;
        	
        	$typeText = "";
        	if($val['type'] == 1){
        	    $typeText = "虚拟商品(卡密)";
        	}
        	else if($val['type'] == 2){
        	    $typeText = "实体商品";
        	}
        	else if($val['type'] == 3){
        	    $typeText = "核销商品";
        	}
        	else if($val['type'] == 4){
        	    $typeText = "虚拟商品";
        	}
        	$val['typeText'] = $typeText;
        	
        	if($val['sales_volume'] == 0){
        	    $sales_volume = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","og.order_id=o.id","LEFT")->where(['o.uniacid'=>UNIACID,'o.status'=>['>',0],'og.goods_id'=>$val['id']])->sum("og.total");
        	    $val['sales_volume'] = intval($sales_volume);
        	    
        	    if($val['sales_volume'] > 0){
        	        Db::name("bbfx_goods")->where(['id'=>$val['id']])->update(['sales_volume'=>$val['sales_volume']]);
        	    }
        	}
        }
        unset($al);
    	$total = Db::name("bbfx_goods")->where($where)->count();
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }

    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
        $list = Db::name("bbfx_goods")->where('id','in',$ids)->where(['mid'=>['>',0]])->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'title');
        
      	$res = Db::name("bbfx_goods")->where('id','in',$ids)->where(['mid'=>['>',0]])->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("删除商品","商品：".implode(",",$titles)."，商品ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }

    
    public function detail(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        $params = $this->param();
        
        $id = intval($params['id']);
        $goods = Db::name("bbfx_goods")->where(['id'=>$id,'mid'=>['>',0]])->find();
        $levels = Fenxiao::getLevels();
        
        
        $result = ['levels'=>$levels];
        if(!empty($goods)){
            $goods['parameter'] = iunserializer($goods['parameter']);
            $goods['levels'] = iunserializer($goods['levels']);
            if(empty($goods['levels'])){
                $goods['levels'] = [];
            }
            $goods['levels'] = iunserializer($goods['levels']);
            foreach ($goods['levels'] as $k => &$v){
                $v = intval($v);
            }
            unset($v);
            
            $goods['slides'] = cdnurls(iunserializer($goods['slides']));
            $goods['videos'] = cdnurls(iunserializer($goods['videos']));
            $goods['thumb'] = cdnurl($goods['thumb']);
            $goods['single_column_thumb'] = cdnurl($goods['single_column_thumb']);
            $goods['authentic_icon'] = cdnurl($goods['authentic_icon']);
            $goods['contract'] = iunserializer($goods['contract']);
            $goods['guarantee'] = iunserializer($goods['guarantee']);
            $goods['share_img'] = cdnurl($goods['share_img']);
            $goods['attr'] = [];
            if($goods['is_recommend'] == 1){
                $goods['attr'][] = 1;
            }
            if($goods['is_new'] == 1){
                $goods['attr'][] = 2;
            }
            if($goods['is_hot'] == 1){
                $goods['attr'][] = 3;
            }
            if($goods['is_nodiscount'] == 1){
                $goods['attr'][] = 4;
            }
            
            $category_ids = [];
            $goods_category = Db::name("bbfx_goods_category")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
            if(!empty($goods_category)){
                $category_ids = array_column($goods_category, 'category_id');
            }
            $goods['category_ids'] = $category_ids;
            
            $goods_category = Db::name("bbfx_category")->where(['uniacid'=>UNIACID,'id'=>['in',$category_ids]])->field("id,pid,title")->select();
            if(empty($goods_category)) $goods_category = [];
            $goods_category_ids = [];
            foreach ($goods_category as $key => $val){
                $two = Db::name("bbfx_category")->where(['uniacid'=>UNIACID,'id'=>$val['pid']])->find();
                if(!empty($two)){
                    $three = Db::name("bbfx_category")->where(['uniacid'=>UNIACID,'id'=>$two['pid']])->find();
                    if(!empty($three)){
                        $val['title'] = $three['title']."/".$two['title']."/".$val['title'];
                        $goods_category_ids[] = [$three['id'],$two['id'],$val['id']];
                    }
                    else{
                        $val['title'] = $two['title']."/".$val['title'];
                        $goods_category_ids[] = [$two['id'],$val['id']];
                    }
                }
                else{
                    $goods_category_ids[] = [$val['id']];
                }
            }
            $goods['goods_category_ids'] = $goods_category_ids;
            
            $hexiao_store_ids = [];
            $store_goods = Db::name("bbfx_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
            if(!empty($store_goods)){
                $hexiao_store_ids = array_column($store_goods, 'store_id');
            }
            $goods['hexiao_store_ids'] = $hexiao_store_ids;
            
            
            
            $goods['commission1'] = iunserializer($goods['commission1']);
            if(empty($goods['commission1'])){
                $goods['commission1'] = [];
            }
            $goods['commission2'] = iunserializer($goods['commission2']);
            if(empty($goods['commission2'])){
                $goods['commission2'] = [];
            }
            $goods['commission3'] = iunserializer($goods['commission3']);
            if(empty($goods['commission3'])){
                $goods['commission3'] = [];
            }
            $goods['jc_reward'] = iunserializer($goods['jc_reward']);
            if(empty($goods['jc_reward'])){
                $goods['jc_reward'] = [];
            }
            $goods['jd_reward'] = iunserializer($goods['jd_reward']);
            if(empty($goods['jd_reward'])){
                $goods['jd_reward'] = [];
            }
            $goods['pj_reward'] = iunserializer($goods['pj_reward']);
            if(empty($goods['pj_reward'])){
                $goods['pj_reward'] = [];
            }
            $goods['ab_reward'] = iunserializer($goods['ab_reward']);
            if(empty($goods['ab_reward'])){
                $goods['ab_reward'] = [];
            }
            $goods['level_discount'] = iunserializer($goods['level_discount']);
            if(empty($goods['level_discount'])){
                $goods['level_discount'] = [];
            }
            $goods['returns'] = iunserializer($goods['returns']);
            if(empty($goods['returns'])){
                $goods['returns'] = ['type'=>0,'day'=>0,'level'=>[],'money1'=>0,'money2'=>0];
            }
            $goods['agent'] = iunserializer($goods['agent']);
            if(empty($goods['agent'])){
                $goods['agent'] = [];
            }
            
            $goods['repurchase_reward1'] = iunserializer($goods['repurchase_reward1']);
            if(empty($goods['repurchase_reward1'])){
                $goods['repurchase_reward1'] = [];
            }
            $goods['repurchase_reward2'] = iunserializer($goods['repurchase_reward2']);
            if(empty($goods['repurchase_reward2'])){
                $goods['repurchase_reward2'] = [];
            }
            $goods['repurchase_reward3'] = iunserializer($goods['repurchase_reward3']);
            if(empty($goods['repurchase_reward3'])){
                $goods['repurchase_reward3'] = [];
            }
            
            $goods['repurchase_pingji_reward'] = iunserializer($goods['repurchase_pingji_reward']);
            if(empty($goods['repurchase_pingji_reward'])){
                $goods['repurchase_pingji_reward'] = [];
            }
            
            $goods['give'] = iunserializer($goods['give']);
            if(empty($goods['give'])){
                $goods['give'] = [];
            }
            
            $goods['cumulative_fanhuan'] = iunserializer($goods['cumulative_fanhuan']);
            if(empty($goods['cumulative_fanhuan'])){
                $goods['cumulative_fanhuan'] = ['level'=>[],'money1'=>'','money2'=>''];
            }
            
            $goods['cloud_warehouse'] = iunserializer($goods['cloud_warehouse']);
            if(empty($goods['cloud_warehouse'])){
                $goods['cloud_warehouse'] = ['level'=>[],'money1'=>'','money2'=>''];
            }
            $goods['cloud_warehouse_chuhuo'] = iunserializer($goods['cloud_warehouse_chuhuo']);
            if(empty($goods['cloud_warehouse_chuhuo'])){
                $goods['cloud_warehouse_chuhuo'] = ['level'=>[],'money1'=>'','money2'=>''];
            }
            
            
            $goods['ladder_push'] = iunserializer($goods['ladder_push']);
            if(empty($goods['ladder_push'])){
                $goods['ladder_push'] = ['level'=>[],'unified'=>[]];
            }
            
            $goods['plugin'] = iunserializer($goods['plugin']);
            if(empty($goods['plugin'])){
                $goods['plugin'] = [];
            }
            
            $commission1 = $goods['commission1'];
            $commission2 = $goods['commission2'];
            $commission3 = $goods['commission3'];
            $repurchase_reward1 = $goods['repurchase_reward1'];
            $repurchase_reward2 = $goods['repurchase_reward2'];
            $repurchase_reward3 = $goods['repurchase_reward3'];
            $jc_reward = $goods['jc_reward'];
            $jd_reward = $goods['jd_reward'];
            $pj_reward = $goods['pj_reward'];
            $ab_reward = $goods['ab_reward'];
            $level_discount = $goods['level_discount'];
            $returns = $goods['returns'];
            $agent = $goods['agent'];
            $give = $goods['give'];
            
            $goods['repurchase_pingji_reward']['money1'] = (array)$goods['repurchase_pingji_reward']['money1'];
            $goods['repurchase_pingji_reward']['money2'] = (array)$goods['repurchase_pingji_reward']['money2'];
            $repurchase_pingji_reward = $goods['repurchase_pingji_reward'];
            $cumulative_fanhuan = $goods['cumulative_fanhuan'];
            $cloud_warehouse = $goods['cloud_warehouse'];
            $cloud_warehouse_chuhuo = $goods['cloud_warehouse_chuhuo'];
            
            $ladder_push = $goods['ladder_push'];
            
            $plugin = $goods['plugin'];
        }
        else{
            $commission1 = [];
            $commission2 = [];
            $commission3 = [];
            $repurchase_reward1 = [];
            $repurchase_reward2 = [];
            $repurchase_reward3 = [];
            $jc_reward = [];
            $jd_reward = [];
            $pj_reward = [];
            $ab_reward = [];
            $repurchase_reward = [];
            $level_discount = [];
            $agent = [];
            $give = [];
            $returns = ['type'=>0,'day'=>0,'level'=>[],'money1'=>0,'money2'=>0];
            $repurchase_pingji_reward = ['money1'=>[],'money2'=>[],'level'=>[]];
            $cumulative_fanhuan = ['level'=>[],'money1'=>'','money2'=>''];
            $cloud_warehouse = ['level'=>[],'money1'=>'','money2'=>''];
            $cloud_warehouse_chuhuo = ['level'=>[],'money1'=>'','money2'=>''];
            
            $ladder_push = ['level'=>[],'unified'=>[]];
            
            $plugin = [];
            
            $goods_category = [];
            $goods_category_ids = [];
        }
        
        if(empty($plugin['coupon'])){
            $plugin['coupon'] = ['is_nouse_coupon'=>0,'give_coupon'=>[],'give_coupon_list'=>[]];
        }
        if(is_null($plugin['coupon']['give_coupon_list'])) $plugin['coupon']['give_coupon_list'] = [];
        if(empty($plugin['queue_mode'])){
            $plugin['queue_mode'] = ['status'=>0,'rule'=>0,'miandan_total'=>['money1'=>'','money2'=>''],'each_order_rate'=>['money1'=>'','money2'=>'']];
        }
        if(empty($plugin['sabonus'])){
            $plugin['sabonus'] = ['status'=>0,'part'=>'','abonus_money'=>''];
        }
        if(is_null($plugin['sabonus']['abonus_money'])){
            $plugin['sabonus']['abonus_money'] = '';
        }
        if(empty($plugin['chaoyue'])){
            $plugin['chaoyue'] = ['status'=>1,'inde_rule'=>0,'reward'=>[]];
        }
        if(empty($plugin['pay'])){
            $plugin['pay'] = ['weixin_pay'=>1,'balance_pay'=>1,'deposit_release_pay'=>1,'repurchase_currency_pay'=>1,'zfb_pay'=>1];
        }
        if(is_null($plugin['pay']['deposit_release_pay'])){
            $plugin['pay']['deposit_release_pay'] = 1;
        }
        if(is_null($plugin['pay']['repurchase_currency_pay'])){
            $plugin['pay']['repurchase_currency_pay'] = 1;
        }
        if(is_null($plugin['pay']['zfb_pay'])){
            $plugin['pay']['zfb_pay'] = 1;
        }
        if(empty($plugin['crazy'])){
            $plugin['crazy'] = ['status'=>0,'crazy_portion'=>''];
        }
        if(empty($plugin['virtual_goods'])){
            $plugin['virtual_goods'] = ['fahuo_content'=>''];
        }
        if(empty($plugin['npingji'])){
            $plugin['npingji'] = ['status'=>1,'inde_rule'=>0,'reward'=>[]];
        }
        if(empty($plugin['form'])){
            $plugin['form'] = ['status'=>0,'list'=>[]];
        }
        if(empty($plugin['capitalpool'])){
            $plugin['capitalpool'] = ['status'=>1,'capitalpool_money'=>''];
        }
        if(empty($plugin['super_maihuo'])){
            $plugin['super_maihuo'] = ['status'=>0,'super_maihuo_portion'=>''];
        }
        if(empty($plugin['jiandan'])){
            $plugin['jiandan'] = ['is_jd_pingji_rule'=>0,'jd_pingji_reward'=>[]];
        }
        if(empty($plugin['ladderabonus'])){
            $plugin['ladderabonus'] = ['status'=>1];
        }
        if(empty($plugin['management'])){
            $plugin['management'] = ['status'=>1];
        }
        if(empty($plugin['laddermanage'])){
            $plugin['laddermanage'] = ['status'=>1];
        }
        if(empty($plugin['gift'])){
            $plugin['gift'] = ['status'=>0,'tx_status'=>0,'cash'=>''];
        }
        
        
        $plugin['coupon']['is_nouse_coupon'] = intval($plugin['coupon']['is_nouse_coupon']);
        $plugin['queue_mode']['status'] = intval($plugin['queue_mode']['status']);
        $plugin['queue_mode']['rule'] = intval($plugin['queue_mode']['rule']);
        $plugin['sabonus']['status'] = intval($plugin['sabonus']['status']);
        $plugin['chaoyue']['status'] = intval($plugin['chaoyue']['status']);
        $plugin['chaoyue']['inde_rule'] = intval($plugin['chaoyue']['inde_rule']);
        $plugin['pay']['weixin_pay'] = intval($plugin['pay']['weixin_pay']);
        $plugin['pay']['balance_pay'] = intval($plugin['pay']['balance_pay']);
        $plugin['pay']['deposit_release_pay'] = intval($plugin['pay']['deposit_release_pay']);
        $plugin['crazy']['status'] = intval($plugin['crazy']['status']);
        $plugin['npingji']['status'] = intval($plugin['npingji']['status']);
        $plugin['npingji']['inde_rule'] = intval($plugin['npingji']['inde_rule']);
        $plugin['form']['status'] = intval($plugin['form']['status']);
        
        $grade1 = [];
        $grade2 = [];
        $grade3 = [];
        $grade1_score = [];
        $grade2_score = [];
        $grade3_score = [];
        
        $repurchase_grade1 = [];
        $repurchase_grade2 = [];
        $repurchase_grade3 = [];
        
        $agent_grade1 = [];
        $agent_grade2 = [];
        $agent_grade3 = [];
        $agent_grade4 = [];
        $agent_grade8 = [];
        
        $chaoyue_reward = $plugin['chaoyue']['reward'];
        $pingji_layer = max(1,$base['fenxiao']['pingji_layer']);
        $npingji_reward = $plugin['npingji']['reward'];
        $jd_pingji_reward = $plugin['jiandan']['jd_pingji_reward'];
        
        foreach ($levels as $key => $val){
            $grade1['level'.$val['id']] = round($commission1['grade']['level'.$val['id']],2);
            $grade2['level'.$val['id']] = round($commission2['grade']['level'.$val['id']],2);
            $grade3['level'.$val['id']] = round($commission3['grade']['level'.$val['id']],2);
            $grade1_score['level'.$val['id']] = round($commission1['grade_score']['level'.$val['id']],2);
            $grade2_score['level'.$val['id']] = round($commission2['grade_score']['level'.$val['id']],2);
            $grade3_score['level'.$val['id']] = round($commission3['grade_score']['level'.$val['id']],2);
            
            $repurchase_grade1['level'.$val['id']] = round($repurchase_reward1['grade']['level'.$val['id']],2);
            $repurchase_grade2['level'.$val['id']] = round($repurchase_reward2['grade']['level'.$val['id']],2);
            $repurchase_grade3['level'.$val['id']] = round($repurchase_reward3['grade']['level'.$val['id']],2);
            
            $jc_reward['level'.$val['id']]['money1'] = round($jc_reward['level'.$val['id']]['money1'],2);
            $jc_reward['level'.$val['id']]['money2'] = round($jc_reward['level'.$val['id']]['money2'],2);
            
            $jd_reward['level'.$val['id']]['money1'] = round($jd_reward['level'.$val['id']]['money1'],2);
            $jd_reward['level'.$val['id']]['money2'] = round($jd_reward['level'.$val['id']]['money2'],2);

            $jd_pingji_reward['level'.$val['id']]['money1'] = round($jd_pingji_reward['level'.$val['id']]['money1'],2);
            $jd_pingji_reward['level'.$val['id']]['money2'] = round($jd_pingji_reward['level'.$val['id']]['money2'],2);
            
            $pj_reward['level'.$val['id']]['money1'] = round($pj_reward['level'.$val['id']]['money1'],2);
            $pj_reward['level'.$val['id']]['money2'] = round($pj_reward['level'.$val['id']]['money2'],2);
            for ($i = 0;$i < $pingji_layer;$i++){
                $pj_reward['level'.$val['id']]['layer'.$i] = round($pj_reward['level'.$val['id']]['layer'.$i],2);
                $pj_reward['level'.$val['id']]['layer_rate'.$i] = round($pj_reward['level'.$val['id']]['layer_rate'.$i],2);
            }
            
            $ab_reward['level'.$val['id']]['money1'] = round($ab_reward['level'.$val['id']]['money1'],2);
            $ab_reward['level'.$val['id']]['money2'] = round($ab_reward['level'.$val['id']]['money2'],2);
            
            $discount = (int)$level_discount['level'.$val['id']]['money1'];
            $discount_price = (int)$level_discount['level'.$val['id']]['money2'];
            if($discount > 10 || $discount <= 0){
                $discount = 10;
            }
            if($discount_price < 0){
                $discount_price = 0;
            }
             
            $level_discount['level'.$val['id']]['money1'] = $discount;
            $level_discount['level'.$val['id']]['money2'] = $discount_price;
            
            if($base['return']['status'] == 1){
                if($base['return']['type'] == 1 || $base['return']['type'] == 2){
                    $returns['level']['level'.$val['id']]['money1'] = round($returns['level']['level'.$val['id']]['money1'],2);
                    $returns['level']['level'.$val['id']]['money2'] = round($returns['level']['level'.$val['id']]['money2'],2);
                }
                else if($base['return']['type'] == 4){
                    if(empty($returns['month']['level'.$val['id']])) $returns['month']['level'.$val['id']] = [];
                    $month = intval($base['return']['return_day']);
                    if($base['return']['return_rule_detailed'] == 1){
                        $month = intval($base['return']['return_rule_content']['level'.$val['id']]['return_day']);
                    }
                    if($month > 0){
                        $month_level = [];
                        for($i = 0;$i < $month;$i++){
                            $month_level[] = [
                                'money1'=>round($returns['month']['level'.$val['id']][$i]['money1'],2),
                                'money2'=>round($returns['month']['level'.$val['id']][$i]['money2'],2)
                            ];
                        }
                        $returns['month']['level'.$val['id']] = $month_level;
                    }
                    else{
                        $returns['month']['level'.$val['id']] = [];
                    }
                }
            }
            
            
            $agent_grade1['level'.$val['id']]['money1'] = round($agent[1]['grade']['level'.$val['id']]['money1'],2);
            $agent_grade1['level'.$val['id']]['money2'] = round($agent[1]['grade']['level'.$val['id']]['money2'],2);
            
            $agent_grade2['level'.$val['id']]['money1'] = round($agent[2]['grade']['level'.$val['id']]['money1'],2);
            $agent_grade2['level'.$val['id']]['money2'] = round($agent[2]['grade']['level'.$val['id']]['money2'],2);
            
            $agent_grade3['level'.$val['id']]['money1'] = round($agent[3]['grade']['level'.$val['id']]['money1'],2);
            $agent_grade3['level'.$val['id']]['money2'] = round($agent[3]['grade']['level'.$val['id']]['money2'],2);
            
            $agent_grade4['level'.$val['id']]['money1'] = round($agent[4]['grade']['level'.$val['id']]['money1'],2);
            $agent_grade4['level'.$val['id']]['money2'] = round($agent[4]['grade']['level'.$val['id']]['money2'],2);
            
            $agent_grade8['level'.$val['id']]['money1'] = round($agent[8]['grade']['level'.$val['id']]['money1'],2);
            $agent_grade8['level'.$val['id']]['money2'] = round($agent[8]['grade']['level'.$val['id']]['money2'],2);
            
            
            $give['level'.$val['id']]['money1'] = round($give['level'.$val['id']]['money1'],2);
            $give['level'.$val['id']]['money2'] = round($give['level'.$val['id']]['money2'],2);
            
            
            $repurchase_pingji_reward['level']['level'.$val['id']]['money1'] = (array)$repurchase_pingji_reward['level']['level'.$val['id']]['money1'];
            $repurchase_pingji_reward['level']['level'.$val['id']]['money2'] = (array)$repurchase_pingji_reward['level']['level'.$val['id']]['money2'];
            
            $cumulative_fanhuan['level']['level'.$val['id']]['money1'] = round($cumulative_fanhuan['level']['level'.$val['id']]['money1'],2);
            $cumulative_fanhuan['level']['level'.$val['id']]['money2'] = round($cumulative_fanhuan['level']['level'.$val['id']]['money2'],2);
            
            $cloud_warehouse['level']['level'.$val['id']]['money1'] = round($cloud_warehouse['level']['level'.$val['id']]['money1'],2);
            $cloud_warehouse['level']['level'.$val['id']]['money2'] = round($cloud_warehouse['level']['level'.$val['id']]['money2'],2);
            
            $cloud_warehouse_chuhuo['level']['level'.$val['id']]['money1'] = round($cloud_warehouse_chuhuo['level']['level'.$val['id']]['money1'],2);
            $cloud_warehouse_chuhuo['level']['level'.$val['id']]['money2'] = round($cloud_warehouse_chuhuo['level']['level'.$val['id']]['money2'],2);
            
            $ladder_push['level']['level'.$val['id']] = (array)$ladder_push['level']['level'.$val['id']];
            
            
            $chaoyue_reward['level'.$val['id']]['money1'] = round($chaoyue_reward['level'.$val['id']]['money1'],2);
            $chaoyue_reward['level'.$val['id']]['money2'] = round($chaoyue_reward['level'.$val['id']]['money2'],2);
            
            $npingji_reward['level'.$val['id']]['money1'] = round($npingji_reward['level'.$val['id']]['money1'],2);
            $npingji_reward['level'.$val['id']]['money2'] = round($npingji_reward['level'.$val['id']]['money2'],2);
            
        }
        if(empty($commission1)){
            $commission1 = ['level'=>['money1'=>'','money2'=>'','money1_score'=>'','money2_score'=>''],'grade'=>$grade1,'grade_score'=>$grade1_score];
        }
        else{
            $commission1['grade'] = $grade1;
            $commission1['grade_score'] = $grade1_score;
        }
        if(empty($commission2)){
            $commission2 = ['level'=>['money1'=>'','money2'=>'','money1_score'=>'','money2_score'=>''],'grade'=>$grade2,'grade_score'=>$grade2_score];
        }
        else{
            $commission2['grade'] = $grade2;
            $commission2['grade_score'] = $grade2_score;
        }
        if(empty($commission3)){
            $commission3 = ['level'=>['money1'=>'','money2'=>'','money1_score'=>'','money2_score'=>''],'grade'=>$grade3,'grade_score'=>$grade3_score];
        }
        else{
            $commission3['grade'] = $grade3;
            $commission3['grade_score'] = $grade3_score;
        }
        
        if(empty($repurchase_reward1)){
            $repurchase_reward1 = ['level'=>['money1'=>'','money2'=>''],'grade'=>$repurchase_grade1];
        }
        else{
            $repurchase_reward1['grade'] = $repurchase_grade1;
        }
        if(empty($repurchase_reward2)){
            $repurchase_reward2 = ['level'=>['money1'=>'','money2'=>''],'grade'=>$repurchase_grade2];
        }
        else{
            $repurchase_reward2['grade'] = $repurchase_grade2;
        }
        if(empty($repurchase_reward3)){
            $repurchase_reward3 = ['level'=>['money1'=>'','money2'=>''],'grade'=>$repurchase_grade3];
        }
        else{
            $repurchase_reward3['grade'] = $repurchase_grade3;
        }
        
        $plugin['chaoyue']['reward'] = $chaoyue_reward;
        $plugin['npingji']['reward'] = $npingji_reward;
        $plugin['jiandan']['jd_pingji_reward'] = $jd_pingji_reward;
        
        if(empty($agent)){
            $agent = array(
                "1"=>array(
                    'level'=>['money1'=>'','money2'=>''],
                    'grade'=>$agent_grade1
                ),
                "2"=>array(
                    'level'=>['money1'=>'','money2'=>''],
                    'grade'=>$agent_grade2
                ),
                "3"=>array(
                    'level'=>['money1'=>'','money2'=>''],
                    'grade'=>$agent_grade3
                ),
                "4"=>array(
                    'level'=>['money1'=>'','money2'=>''],
                    'grade'=>$agent_grade4
                ),
                "8"=>array(
                    'level'=>['money1'=>'','money2'=>''],
                    'grade'=>$agent_grade8
                ),
            );
        }
        else{
            $agent[1]['grade'] = $agent_grade1;
            $agent[2]['grade'] = $agent_grade2;
            $agent[3]['grade'] = $agent_grade3;
            $agent[4]['grade'] = $agent_grade4;
            if(empty($agent[8])) $agent[8] = array(
                    'level'=>['money1'=>'','money2'=>''],
                    'grade'=>[]
                );
            $agent[8]['grade'] = $agent_grade8;
        }
        
        
        
        
        
        if(!empty($goods)){
            $goods['plugin'] = $plugin;
            
            
            $goods['commission1'] = $commission1;
            $goods['commission2'] = $commission2;
            $goods['commission3'] = $commission3;
            
            $goods['jc_reward'] = $jc_reward;
            $goods['jd_reward'] = $jd_reward;
            $goods['pj_reward'] = $pj_reward;
            $goods['ab_reward'] = $ab_reward;
            
            $goods['repurchase_reward1'] = $repurchase_reward1;
            $goods['repurchase_reward2'] = $repurchase_reward2;
            $goods['repurchase_reward3'] = $repurchase_reward3;
            
            $goods['cumulative_fanhuan'] = $cumulative_fanhuan;
            $goods['cloud_warehouse'] = $cloud_warehouse;
            $goods['cloud_warehouse_chuhuo'] = $cloud_warehouse_chuhuo;
            
            $goods['ladder_push'] = $ladder_push;
            
            $goods['level_discount'] = $level_discount;
            
            $goods['returns'] = $returns;
            
            $goods['agent'] = $agent;
            $goods['give'] = $give;
            $goods['repurchase_pingji_reward'] = $repurchase_pingji_reward;
            
            $spec = Db::name("bbfx_goods_spec")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->field("id,name")->order("id asc")->select();
            $spec_item_list = [];
            if(!empty($spec)){
                foreach ($spec as $key => &$val){
                    $spec_items = Db::name("bbfx_goods_spec_item")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id'],'pid'=>$val['id']])->field("id,name")->select();
                    foreach ($spec_items as $k => &$v){
                        $v['pindex'] = $key;
                        $v['index'] = $k;
                        $spec_item_list[$v['id']] = $key."_".$k;
                    }
                    unset($v);
                    $val['spec_item'] = $spec_items;
                }
                unset($val);
                
                $sku_list = Db::name("bbfx_goods_spec_sku")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
                $sku_data = [];
                foreach ($sku_list as $key => $val){
                    $sku = explode(",",$val['sku']);
                    $sku_key = [];
                    foreach ($sku as $k => $v){
                        
                        $sku_key[] = $spec_item_list[$v];
                    }
                    $sku_key = implode(",",$sku_key);
                    $sku_data['price'][$sku_key] = $val['price']; 
                    $sku_data['profit_amount'][$sku_key] = $val['profit_amount']; 
                    $sku_data['original_price'][$sku_key] = $val['original_price'];
                    $sku_data['volume'][$sku_key] = $val['volume'];
                    $sku_data['weight'][$sku_key] = $val['weight'];
                    $sku_data['stock'][$sku_key] = $val['stock'];
                    $sku_data['cost_price'][$sku_key] = $val['cost_price'];
                    $sku_data['thumb'][$sku_key] = cdnurl($val['thumb']);
                }
                $goods['sku_data'] = $sku_data;
            }
            else{
                $goods['is_spec'] = 0;
            }
            
            $goods['spec'] = $spec;
            
            
            
            
            
            $result['goods'] = $goods;
        }
        $result['plugin'] = $plugin;
        
        $result['commission1'] = $commission1;
        $result['commission2'] = $commission2;
        $result['commission3'] = $commission3;
        
        $result['jc_reward'] = $jc_reward;
        $result['jd_reward'] = $jd_reward;
        $result['pj_reward'] = $pj_reward;
        $result['ab_reward'] = $ab_reward;
        $result['repurchase_reward1'] = $repurchase_reward1;
        $result['repurchase_reward2'] = $repurchase_reward2;
        $result['repurchase_reward3'] = $repurchase_reward3;
        $result['level_discount'] = $level_discount;
        $result['returns'] = $returns;
        $result['agent'] = $agent;
        $result['give'] = $give;
        $result['repurchase_pingji_reward'] = $repurchase_pingji_reward;
        $result['cumulative_fanhuan'] = $cumulative_fanhuan;
        $result['cloud_warehouse'] = $cloud_warehouse;
        $result['cloud_warehouse_chuhuo'] = $cloud_warehouse_chuhuo;
        
        $result['ladder_push'] = $ladder_push;
        $contract_list = Db::name("bbfx_contract")->where(['uniacid'=>UNIACID,'type'=>1])->field("id,name")->select();
        $result['contract_list'] = $contract_list;
        
        $coupon_list = Db::name("bbfx_coupon")->where(['uniacid'=>UNIACID,'status'=>1])->select();
        $result['coupon_list'] = $coupon_list;
        
        $result['goods_category'] = $goods_category;
        __success("操作成功",$result);
    }
    
    public function post(){
        $params = $this->param();
        
        
        $id = intval($params['id']);
        $goods = Db::name("bbfx_goods")->where(['id'=>$id,'mid'=>['>',0]])->find();
        
        $msg = "";
      	$sort = intval($params['sort']);
      	if(empty($params['title'])){
        	$msg = "请填写商品名称";
        }
      	if(empty($params['thumb'])){
        	$msg = "请上传商品图片";
        }
      	
        if($params['plugin']['form']['status'] == 1 && empty($params['plugin']['form']['list'])){
            $msg = "请添加表单";
        }
      
      	if($msg){
        	__error($msg);
        }
        $type = max(1,intval($params['type']));
        
        if(!empty($goods)){
            $type = $goods['type'];
        }
        
        $price = floatval($params['price']);
        $o_price = floatval($params['o_price']);
        // $content = htmlspecialchars_decode($params['content']); 
        $content = htmlspecialchars_decode($this->param("content/h"));
        
    	$data = array(
        	"uniacid"=>UNIACID,
          	"mid"=>intval($params['mid']),
          	"title"=>$params['title'],
          	"subtitle"=>$params['subtitle'],
          	"thumb"=>$params['thumb'],
          	"price"=>$price,
          	"o_price"=>$o_price,
          	"cost_price"=>max(0,round($params['cost_price'],2)),
          	"express_fee"=>floatval($params['express_fee']),
          	"profit_amount"=>floatval($params['profit_amount']),
          	"stock_type"=>intval($params['stock_type']),
          	"minbuy"=>max(1,intval($params['minbuy'])),
          	"maxbuy"=>intval($params['maxbuy']),
          	"daily_buy"=>intval($params['daily_buy']),
          	"monthly_buy"=>intval($params['monthly_buy']),
          	"total_maxbuy"=>intval($params['total_maxbuy']), 
          	"shippingfee_template_id"=>intval($params['shippingfee_template_id']), 
          	"weight"=>round($params['weight'],2), 
          	"volume"=>round($params['volume'],2), 
          	"is_give"=>intval($params['is_give']),
          	"give_type"=>intval($params['give_type']),
          	"give"=>iserializer($params['give']),
          	"levels"=>iserializer($params['levels']),
          	"is_contract"=>intval($params['is_contract']),
          	"contract"=>iserializer($params['contract']),
          	"guarantee"=>iserializer($params['guarantee']),
          	"fastest_delivery"=>intval($params['fastest_delivery']),
          	"arrive_day"=>intval($params['arrive_day']),
          	"express_name"=>$params['express_name'],
          	"vip_free_shipping"=>intval($params['vip_free_shipping']),
          	"is_authentic"=>intval($params['is_authentic']),
          	"authentic_name"=>$params['authentic_name'],
          	"authentic_desc"=>$params['authentic_desc'],
          	"status"=>$params['status'],
          	"single_column_thumb"=>replaceSiteroot($params['single_column_thumb']),
          	"authentic_icon"=>replaceSiteroot($params['authentic_icon']),
          	"content"=>$content,
          	"sort"=>$sort,
          	"is_recommend"=>0,
          	"is_new"=>0,
          	"is_hot"=>0,
          	"is_nodiscount"=>0,
          	// "stock"=>intval($params['stock']),
          	"is_spec"=>intval($params['is_spec']),
          	"delivery_method"=>intval($params['delivery_method']),
          	"virtual_sale"=>intval($params['virtual_sale']),
          	"plugin"=>iserializer($params['plugin']),
          	"parameter"=>iserializer($params['parameter']),
          	"is_hexiao_quantity"=>intval($params['is_hexiao_quantity']),
          	"buy_btn"=>trim($params['buy_btn']),
          	"updatetime"=>time()
        );

        if($data['mid'] <= 0){
            __error("请选择商户");
        }
        
        if($type == 2 && ($params['delivery_method'] == 2 || $params['delivery_method'] == 3) || ($type == 4 && intval($params['is_hexiao']) == 1)){
            $data['is_hexiao'] = 1;
            $data['hexiao_num'] = max(1,intval($params['hexiao_num']));
            $data['hexiao_store_type'] = intval($params['hexiao_store_type']);
            if($params['hexiao_store_type'] == 1){
                if(empty($params['hexiao_store_ids'])){
                    __error("请选择核销门店");
                }
                $store = Db::name("bbfx_store")->where(['uniacid'=>UNIACID,'type'=>1,'mid'=>$data['mid'],'id'=>['in',$params['hexiao_store_ids']]])->find();
                if(empty($store)){
                    __error("请选择核销门店");
                }
            }
            
        }
        else{
            $data['is_hexiao'] = 0;
        }
        
        $gift = $params['plugin']['gift'];
        if($gift['status'] == 1 && $gift['tx_status'] == 1){
            if(round($gift['cash'],2) <= 0){
                __error("请输入提现金额");
            }
        }
        
        // 分销配置
        $data['is_fenxiao'] = intval($params['is_fenxiao']);
        $data['commission_rule'] = intval($params['commission_rule']);
        $data['commission1'] = iserializer($params['commission1']);
        $data['commission2'] = iserializer($params['commission2']);
        $data['commission3'] = iserializer($params['commission3']);
        $data['is_repurchase_rule'] = intval($params['is_repurchase_rule']);
        $data['repurchase_reward1'] = iserializer($params['repurchase_reward1']);
        $data['repurchase_reward2'] = iserializer($params['repurchase_reward2']);
        $data['repurchase_reward3'] = iserializer($params['repurchase_reward3']);
        $data['is_jicha_rule'] = intval($params['is_jicha_rule']);
        $data['is_jiandan_rule'] = intval($params['is_jiandan_rule']);
        $data['is_pingji_rule'] = intval($params['is_pingji_rule']);
        $data['is_abonus_rule'] = intval($params['is_abonus_rule']);
        $data['is_abonus'] = intval($params['is_abonus']);
        $data['upgrade_score'] = intval($params['upgrade_score']);
        $data['is_leveldiscount_rule'] = intval($params['is_leveldiscount_rule']);
        $data['is_return'] = intval($params['is_return']);
        $data['is_return_rule'] = intval($params['is_return_rule']);
        $data['is_agent'] = intval($params['is_agent']);
        $data['agent_rule'] = intval($params['agent_rule']);
        $data['jc_reward'] = iserializer($params['jc_reward']);
        $data['jd_reward'] = iserializer($params['jd_reward']);
        $data['pj_reward'] = iserializer($params['pj_reward']);
        $data['ab_reward'] = iserializer($params['ab_reward']);
        
        
        $data['is_repurchase'] = (int)$params['is_repurchase'];
        $data['is_repurchase_pingji'] = (int)$params['is_repurchase_pingji'];
        $data['is_repurchase_pingji_rule'] = (int)$params['is_repurchase_pingji_rule'];
        $data['repurchase_pingji_reward'] = iserializer($params['repurchase_pingji_reward']);
        
        $level_discount = $params['level_discount'];
        $data['level_discount'] = iserializer($level_discount);
        $data['returns'] = iserializer($params['returns']);
        
        $data['agent'] = iserializer($params['agent']);
        
        $data['is_cumulative_fanhuan'] = (int)$params['is_cumulative_fanhuan'];
        $data['cumulative_fanhuan_rule'] = (int)$params['cumulative_fanhuan_rule'];
        $data['cumulative_fanhuan'] = iserializer($params['cumulative_fanhuan']);
        
        $data['cloud_warehouse_rule'] = (int)$params['cloud_warehouse_rule'];
        $data['cloud_warehouse'] = iserializer($params['cloud_warehouse']);
        $data['cloud_warehouse_chuhuo'] = iserializer($params['cloud_warehouse_chuhuo']);
        
        
        $data['is_ladder_push'] = (int)$params['is_ladder_push'];
        $data['is_ladder_push_loop'] = (int)$params['is_ladder_push_loop'];
        $data['ladder_push_rule'] = (int)$params['ladder_push_rule'];
        $data['ladder_push'] = iserializer($params['ladder_push']);
        
        
        $attr = $params['attr'];
        if(in_array(1,$attr)){
            $data['is_recommend'] = 1;
        }
        if(in_array(2,$attr)){
            $data['is_new'] = 1;
        }
        if(in_array(3,$attr)){
            $data['is_hot'] = 1;
        }
        if(in_array(4,$attr)){
            $data['is_nodiscount'] = 1;
        }
        
        
        $data['share_title'] = $params['share_title'];
        $data['share_img'] = $params['share_img'];
        
        
        $data["slides"] = iserializer(replaceSiteroots($params['slides']));
        $data["videos"] = iserializer(replaceSiteroots($params['videos']));
        $data['share_img'] = replaceSiteroot($data['share_img']);
        $data['thumb'] = replaceSiteroot($data['thumb']);
        
        $spec_list = $params['spec'];
        if(empty($spec_list)){
            $data['is_spec'] = 0;
        }
        
        if($type == 1 && ($type == 2 && $data['is_spec'] == 1)){
            unset($data['stock']);
        }
        
        // echo "<pre>";
        // print_r($data);die;
      	if(!empty($goods)){
            $res = Db::name("bbfx_goods")->where(["id"=>$goods['id']])->update($data);
        }
      	else{
      	    
      	    $data['type'] = $type;
          	$data['createtime'] = time();
          	
            $id = Db::name("bbfx_goods")->insertGetId($data);
            $res = $id;
        }
        
        
        
        if($id){
            $data['id'] = $id;
            $res = true;
            $category_ids = $params['category_ids'];
            $categorys = Db::name("bbfx_goods_category")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
            $categorys = array_skey($categorys,'category_id');
            $c_ids = [];
            $goods_category_ids = $params['goods_category_ids'];
            $category_ids = [];
            foreach ($goods_category_ids as $key => $val){
                $category_ids[] = $val[count($val)-1];
            }
            
            if(!empty($category_ids)){
                foreach ($category_ids as $key => $val){
                    $c_ids[$val] = true;
                    if(!empty($val) && empty($categorys[$val])){
                        Db::name("bbfx_goods_category")->insert(['uniacid'=>UNIACID,'goods_id'=>$id,'category_id'=>$val]);
                    }
                }
            }
            foreach ($categorys as $key => $val){
                if(empty($c_ids[$val['category_id']])){
                    Db::name("bbfx_goods_category")->where(['id'=>$val['id']])->delete();
                }
            }
            
            
            if($data['is_hexiao'] == 1){
                $hexiao_store_ids = $params['hexiao_store_ids'];
                $store_goods = Db::name("bbfx_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
                $store_goods = array_skey($store_goods,'store_id');
                $s_ids = [];
                if(!empty($hexiao_store_ids)){
                    foreach ($hexiao_store_ids as $key => $val){
                        $s_ids[$val] = true;
                        if(empty($store_goods[$val])){
                            Db::name("bbfx_store_goods")->insert(['uniacid'=>UNIACID,'goods_id'=>$id,'store_id'=>$val]);
                        }
                    }
                }
                foreach ($store_goods as $key => $val){
                    if(empty($s_ids[$val['store_id']])){
                        Db::name("bbfx_store_goods")->where(['id'=>$val['id']])->delete();
                    }
                }
                
            }
            
            if($data['is_spec'] == 1){
                $spec_item_ids = [];
                $spec_all = Db::name("bbfx_goods_spec")->where(['uniacid'=>UNIACID,'goods_id'=>$id])->select();
                $spec_item_all = Db::name("bbfx_goods_spec_item")->where(['uniacid'=>UNIACID,'goods_id'=>$id])->select();
                $spec_ok = [];
                $spec_item_ok = [];
                
                foreach($spec_list as $key => &$val){
                    $goods_spec = array(
                        "uniacid"=>UNIACID,
                        "goods_id"=>$id,
                        "name"=>$val['name']
                    );
                    $spec_id = intval($val['id']);
                    if($spec_id > 0){
                        Db::name("bbfx_goods_spec")->where(['id'=>$spec_id])->update($goods_spec);
                    }
                    else{
                        $spec_id = Db::name("bbfx_goods_spec")->insertGetId($goods_spec);
                    }
                    
                    $spec_ok[$spec_id] = true;
                    
                    foreach ($val['spec_item'] as $k => $v){
                        $goods_spec_item = array(
                            "uniacid"=>UNIACID,
                            "goods_id"=>$id,
                            "pid"=>$spec_id,
                            "name"=>$v['name']
                        );
                        $spec_item_id = intval($v['id']);
                        if($spec_item_id > 0){
                            Db::name("bbfx_goods_spec_item")->where(['id'=>$spec_item_id])->update($goods_spec_item);
                        }
                        else{
                            $spec_item_id = Db::name("bbfx_goods_spec_item")->insertGetId($goods_spec_item);
                        }
                        $spec_item_ok[$spec_item_id] = true;
                        $spec_item_ids[$key."_".$k] = $spec_item_id;
                        $val['spec_item'][$k]['id'] = $spec_item_id;
                    }
                }
                unset($val);
                
                foreach ($spec_all as $key => $val){
                    if(empty($spec_ok[$val['id']])){
                        Db::name("bbfx_goods_spec")->where(['id'=>$val['id']])->delete();
                    }
                }
                foreach ($spec_item_all as $key => $val){
                    if(empty($spec_item_ok[$val['id']])){
                        Db::name("bbfx_goods_spec_item")->where(['id'=>$val['id']])->delete();
                    }
                }
                
                
                $sku_list = $params['sku_list'];
                
                $spec_sku_all = Db::name("bbfx_goods_spec_sku")->where(['uniacid'=>UNIACID,'goods_id'=>$id])->select();
                $spec_sku_list = array_skey($spec_sku_all,"id");
                $spec_sku_all = array_skey($spec_sku_all,"sku");
                $spec_sku_ok = [];
                foreach ($sku_list as $key => $val){
                    $specs = $val['spec'];
                    $sku = [];
                    $sku_name = [];
                    foreach ($specs as $k => $v){
                        $spec_id = $spec_item_ids[$v['pindex']."_".$v['index']];
                        // print_r($v['pindex']."_".$v['index']);die;
                        if(empty($spec_id)){
                            $sku = [];
                            break;
                        }
                        $sku[] = $spec_id;
                        $sku_name[] = $v['name'];
                    }
                    $sku = implode(",",$sku);
                    $spec_sku_id = intval($spec_sku_all[$sku]['id']);
                    $sku_name = implode(",",$sku_name);
                    $thumb = replaceSiteroot($val['thumb']);
                    $spec_sku = array(
                        "uniacid"=>UNIACID,
                        "goods_id"=>$id,
                        "sku"=>$sku,
                        "sku_name"=>$sku_name,
                        "price"=>floatval($val['price']),
                        "profit_amount"=>floatval($val['profit_amount']),
                        "original_price"=>floatval($val['original_price']),
                        "weight"=>floatval($val['weight']),
                        "volume"=>floatval($val['volume']),
                        // "stock"=>intval($val['stock']),
                        "cost_price"=>max(0,round($val['cost_price'],2)),
                        "thumb"=>$thumb
                    );
                    
                    $sku_stock = 0;
                    if($spec_sku_id > 0){
                        Db::name("bbfx_goods_spec_sku")->where(['id'=>$spec_sku_id])->update($spec_sku);
                        $sku_stock = intval($val['stock'] - $spec_sku_all[$sku]['stock']);
                    }
                    else{
                        $spec_sku_id = Db::name("bbfx_goods_spec_sku")->insertGetId($spec_sku);
                        $sku_stock = $val['stock'];
                    }
                    
                    if($sku_stock != 0){
                        GoodsModel::setStock($id,$spec_sku_id,$sku_stock,$this->auth->id,0,0,"管理员操作");
                    }
                    
                    $spec_sku_ok[$spec_sku_id] = true;
                }
                foreach ($spec_sku_list as $key => $val){
                    if(empty($spec_sku_ok[$val['id']])){
                        Db::name("bbfx_goods_spec_sku")->where(['id'=>$val['id']])->delete();
                    }
                }
            }
            else{
                if(!empty($goods)){
                    $stock = intval($params['stock']) - $goods['stock'];
                }
                else{
                    $stock = intval($params['stock']);
                }
                if($stock != 0){
                    GoodsModel::setStock($id,0,$stock,$this->auth->id,0,0,"管理员操作");
                }
            }
            GoodsModel::resetStock(UNIACID,$id);
        }
        if(empty($res)){
            __error("操作失败",$data);
        }
        
        
        \app\admin\model\AdminLog::record("","",$data,"bbfx_goods");
        
      	__success("编辑成功");
        
    }
}