<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\merchant;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Withdrawal extends Base
{
 
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Merchant;
    }
     
    public function check(){
        global $_W;
        $params = $this->param();
        
        $id = intval($params['id']);
        $status = intval($params['status']);
        $log = Db::name("bbfx_withdrawal_log")->where(["uniacid"=>UNIACID,"id"=>$id,'withdrawal_type'=>7])->find();
        if(empty($log)){
            __error("提现记录不存在"); 
        }
        
        if(!in_array($status,[1,2])){
            __error("提现状态错误");  
        }
        
        if($log['status'] != 0){
            __error("已审核");  
        }
        
        try {
            Db::startTrans();
            
            $res = Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update(["status"=>$status]);
            if($res){
                if($status == 1){
                    Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update(["paytime"=>time()]);
                    if($log['type'] == 2){
                        
                        $merchant = Db::name("bbfx_merchant")->where(['id'=>$log['user_id']])->find();
                        $user = User::getUser($merchant['user_id']);
                        if(empty($user) || empty($user['openid'])){
                            throw new \Exception("未查询到用户微信openid");
                        }
                        
                        $out_batch_no = $log['out_batch_no'];
                        if(empty($out_batch_no)){
                            $out_batch_no = date("YmdHis").random(8,true);
                            Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update(['out_batch_no'=>$out_batch_no]);
                        }
                        Db::name("bbfx_withdrawal_log")->where(['out_batch_no'=>$out_batch_no,'uniacid'=>$_W['uniacid']])->update(['batch_id'=>$res['data']['batch_id']]);
                        
                        if($_W['base']['is_merch_transfer_new'] == 1){
                            $res = \app\common\model\bbfxshop\Wxpay::newTransfer($user['openid'],$log['realmoney'],$out_batch_no,$log['realname'],"商户提现",$user['platform']);
                            if($res['code'] != 1){
                                throw new \Exception($res['message']);
                            }
                            $data = [
                                'batch_id'=>$res['data']['transfer_bill_no']
                            ];
                            if(!empty($res['data']['package_info'])){
                                $data['package_info'] = $res['data']['package_info'];
                            }
                            $data['is_confirm'] = 0;
                        }
                        else{
                            $res = \app\common\model\bbfxshop\Wxpay::transfer($user['openid'],$log['realmoney'],$out_batch_no,$log['withdrawal_no'],$log['realname'],"商户提现");
                            if(empty($res) || $res['code'] != 1){
                                throw new \Exception($res['message']);
                            }
                            $data = [
                                'batch_id'=>$res['data']['batch_id']
                            ];
                        }
                        Db::name("bbfx_withdrawal_log")->where(['out_batch_no'=>$out_batch_no,'uniacid'=>UNIACID])->update($data);
                    }
                    else if($log['type'] == 1){
                        throw new \Exception("未开启该打款方式");
                    }
                    else if($log['type'] == 6){
                        throw new \Exception("未开启该打款方式");
                    }
                }
                else{
                    $this->model->setUserMoney($log['user_id'],$log['money'],1,3,"提现驳回",$log);
                }
                
                \app\admin\model\AdminLog::record("","",['id'=>$log['id'],"status"=>$status],"bbfx_withdrawal_log");
            }
            else{
                throw new \Exception("操作失败");
            }
            
            Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
            __error(0,$e->getMessage());
        }
        
         \app\common\model\bbfxshop\Sms::sendWithdrawalResultNotice($log);
        
        __success("操作成功"); 
        
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        $where = array("a.uniacid"=>UNIACID,'a.withdrawal_type'=>7);
        $status = intval($params['status']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        
        $keyword = trim($params['keyword']);
        
        $type = max(1,intval($params['type']));
        if(!empty($keyword)){
            
            if($type == 1){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['a.realname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['b.mobile'] = $keyword;
            }
            else if($type == 4){
                $where['a.user_id'] = intval($keyword);
            }
        }
         
        if($status){
            $where['a.status'] = $status;
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        }
        
        if($endTime){
            $whereTime['a.createtime'] = ['<=',$endTime];
        }
        
        $list = Db::name("bbfx_withdrawal_log")->alias("a")->join("bbfx_merchant b","a.user_id=b.id")->where($where)->where($whereTime)->field('a.*,b.name as merchant_name,b.logo as merchant_logo')->order('a.createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
        
    	foreach($list as &$val){
    	    $val['merchant_logo'] = cdnurl($val['merchant_logo']);
    	    $val['skqrcode'] = cdnurl($val['skqrcode']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    if($val['paytime']){
    	        $val['paytime'] = date("Y-m-d H:i:s",$val['paytime']);
    	    }
    	    else{
    	        $val['paytime'] = "";
    	    }
    	}
    	unset($val);
      
    	$total = Db::name("bbfx_withdrawal_log")->alias("a")->join("bbfx_merchant b","a.user_id=b.id")->where($where)->where($whereTime)->count();
      	
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    
}