<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\returns;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Config extends Base
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\ReturnMode;
    }
    
    public function set(){
        $params = $this->param();
        $config = Db::name("bbfx_return")->where(["uniacid"=>UNIACID])->find();
        
        $data = array(
            "uniacid"=>UNIACID,
      	    "status"=>intval($params['status']),
      	    "type"=>intval($params['type']),
      	    "currency"=>intval($params['currency']),
      	    "return_total"=>intval($params['return_total']),
      	    "return_total_score"=>intval($params['return_total_score']),
      	    "return_day"=>intval($params['return_day']),
      	    "return_rule"=>intval($params['return_rule']),
      	    "return_type"=>intval($params['return_type']),
      	    "return_rule_detailed"=>intval($params['return_rule_detailed']),
      	    "return_jiaquan"=>intval($params['return_jiaquan'])
        );
        
        $rule_list = $params['rule_list'];
        $return_rule_content = $params['return_rule_content'];
        if($data['type'] == 2 && $data['return_rule'] == 1 && $data['return_day'] <= 0){
            __error("请填写返还天数");
        }
        if($data['status'] == 1 && $data['type'] == 4 && $data['return_day'] > 100){
            __error('返还月数不得大于100');
        }
        
        if($data['return_rule'] == 2){
            foreach ($rule_list as $key => $val){
                $single_purchase_money = intval($val['single_purchase_money']);
                $return_rate = intval($val['return_rate']);
                $return_day = intval($val['return_day']);
                if($single_purchase_money <= 0){
                    __error("请填写单笔消费金额");
                }
                if($return_rate <= 0){
                    __error("请填写返还比例");
                }
                if($return_day <= 0 && $data['type'] == 2){
                    __error("请填写返还天数");
                }
            }
        }
        else{
            if($data['return_total'] < 0){
                __error("请填写返还比例");
            }
        }
        
        if($data['return_rule_detailed'] == 1){
            foreach ($return_rule_content as $key => $val){
                $return_total = intval($val['return_total']);
                $return_day = intval($val['return_day']);
                $return_speed = intval($val['return_speed']);
                if($return_total < 0){
                    // __error("请填写返还比例");
                }
                if($return_day < 0 && $data['type'] == 2){
                    __error("请填写返还天数");
                }
                if($return_speed < 1 && $data['type'] == 3){
                    __error("请填写返还速度");
                }
                
            }
            $data['return_rule_content'] = iserializer($return_rule_content);
        }
        else{
            if($data['return_rule'] == 2){
                foreach ($return_rule_content as $key => $val){
                    $return_speed = intval($val['return_speed']);
                    if($return_speed < 1 && $data['type'] == 3){
                        __error("请填写返还速度");
                    }
                }
                $data['return_rule_content'] = iserializer($return_rule_content);
            }
        }
        
        
    	if(!empty($config)){
    	    if(empty($config['return_date']) || (!empty($config['return_date']) && $config['return_rule']!=1 && $data['return_rule'] == 1)){
                $data['return_date'] = date("Y-m-d");
            }
          	$res = Db::name("bbfx_return")->where(["id"=>$config['id']])->update($data);
        }
      	else{
      	    $data['return_date'] = date("Y-m-d");
        	$res = Db::name("bbfx_return")->insert($data);
        }
        
        
        
        
        if($data['return_rule'] == 2){
            $rule_all = Db::name("bbfx_return_rule")->where(['uniacid'=>UNIACID])->field(['id','single_purchase_money','return_rate'])->order('single_purchase_money asc')->select();
            $rule_ok = [];
            foreach ($rule_list as $key => $val){
                $rule_id = intval($val['id']);
                $single_purchase_money = intval($val['single_purchase_money']);
                $return_rate = intval($val['return_rate']);
                $return_day = intval($val['return_day']);
                
                $rule_data = ['uniacid'=>UNIACID,'single_purchase_money'=>$single_purchase_money,'return_rate'=>$return_rate,'return_day'=>$return_day];
                
                if($rule_id > 0){
                    $rule_ok[$rule_id] = true;
                    Db::name("bbfx_return_rule")->where(['id'=>$rule_id])->update($rule_data);
                }
                else{
                    Db::name("bbfx_return_rule")->insert($rule_data);
                }
            }
            
            foreach ($rule_all as $key => $val){
                if(empty($rule_ok[$val['id']])){
                    Db::name("bbfx_return_rule")->where(['id'=>$val['id']])->delete();
                }
            }
            $res = true;
        }
        
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_return");
            __success("编辑成功",$data);
        }
      	else{
      	    __success("操作成功",$data);
      	}
    }
}