<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\short_video;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Video extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\ShortVideo;
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("uniacid"=>UNIACID);
        
        $list = Db::name("bbfx_short_video_list")->where($where)->order('id desc')->limit(($pindex - 1) * $psize,$psize)->select();
        $total = Db::name("bbfx_short_video_list")->where($where)->count();
        
        foreach ($list as $key => &$val){
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        }
        unset($val);
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function status(){
        $params = $this->param();
        
        $res = Db::name("bbfx_short_video_list")->where("id",$params['id'])->update(['status'=>$params['status']]);
        if($res){
            \app\admin\model\AdminLog::record("","",["id"=>$params['id'],'status'=>$params['status']],"bbfx_short_video_list");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function detail(){
        $params = $this->param();
        
        $info = Db::name("bbfx_short_video_list")->where("id",$params['id'])->find();
        
        if(empty($info)){
            __error("视频不存在");
        }
        $info['video'] = cdnurl($info['video']);
        
        __success('操作成功',$info);
    }
    
    public function post(){
        $params = $this->param();
        $data = array(
            "uniacid"=>UNIACID,
            "title"=>$params['title'],
            "video"=>trim($params['video']),
            "goods_id"=>intval($params['goods_id']),
            "status"=>intval($params['status']),
            "is_recommend"=>intval($params['is_recommend']),
            "sh_status"=>1
        );
        
        if(empty($data['video'])){
            __error("请上传视频");
        }
        
        $data['video'] = replaceSiteroot($data['video']);
        if(!empty($params['id'])){
            $res = Db::name("bbfx_short_video_list")->where("id",$params['id'])->update($data);
            $data['id'] = $params['id'];
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_short_video_list")->insertGetId($data);
            $data['id'] = $res;
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_short_video_list");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
      	$res = Db::name("bbfx_short_video_list")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_short_video_list");
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}