<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\signin;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Config extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Signin;
    }
    
    public function set(){
        $params = $this->param();
        
        $config = Db::name("bbfx_signin")->where(["uniacid"=>UNIACID])->find();
        
        // continuity_signin_rule [{day=>'','signin_reward'=>'','reward_type'=>1,'icon'=>''}]
        
        $continuity_signin_rule = $params['continuity_signin_rule'];
        foreach ($continuity_signin_rule as $key => &$val){
            $val['signin_reward'] = round($val['signin_reward'],2);
            $val['day'] = intval($val['day']);
            $val['icon'] = replaceSiteroot($val['icon']);
            if($val['day'] <= 0){
                __error("请输入连续签到天数");
            }
            if($val['signin_reward'] <= 0){
                __error("请输入连续签到奖励");
            }
        }
        unset($val);
        
        $days = array_column($continuity_signin_rule,'day');
        array_multisort($days,SORT_ASC,$continuity_signin_rule);
        
        $data = array(
            "uniacid"=>UNIACID,
            "status"=>$params['status'],
            "signin_reward"=>$params['signin_reward'],
            "day"=>(int)$params['day'],
            "reward_type"=>(int)$params['reward_type'],
            "continuity_signin_rule"=>iserializer($continuity_signin_rule),
            "sdesc"=>htmlspecialchars_decode($this->param('sdesc/h')),
            "bg"=>replaceSiteroot($params['bg']),
            "pop_image"=>replaceSiteroot($params['pop_image']),
            "signin_icon"=>replaceSiteroot($params['signin_icon']),
            "signin_on_color"=>implode(",",$params['signin_on_color']),
            "signin_color"=>$params['signin_color'],
            "haowu_recommend_image"=>replaceSiteroot($params['haowu_recommend_image']),
            "btn_right_image"=>replaceSiteroot($params['btn_right_image']),
        );
        
    	if(!empty($config)){
          	$res = Db::name("bbfx_signin")->where(["id"=>$config['id']])->update($data);;
        }
      	else{
        	$res = Db::name("bbfx_signin")->insert($data);
        }
        
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_signin");
            __success("编辑成功",$data);
        }
      	else{
      	    __success("操作成功",$data);
      	}
    }
}