<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\sverify;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class ProductCode extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Sverify;
    }
    
    public function getList(){
        
        $params = $this->param();
        
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $where = ["a.uniacid"=>UNIACID];
        
        $export = intval($params['export']);
        $product_id = intval($params['product_id']);
        if($product_id > 0){
            $where['a.product_id'] = $product_id;
        }
        $export_list = [];
        if($export == 1){
            $pindex = 1;
            $psize = 999999;
        }
        
        $list = Db::name("bbfx_sverify_product_code")->alias("a")->join("bbfx_sverify_product b","a.product_id=b.id","LEFT")->where($where)->field("a.*,b.name,b.image")->order('a.id desc')->limit(($pindex - 1) * $psize,$psize)->select();
    	
    	foreach ($list as $key => &$val) {
    	    
    	    $val['image'] = cdnurl($val['image']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    
    	    if($export == 1){
    	        $export_list[] = [
    	            $val['name'],
    	            $val['code'],
    	            ROOT_PATH.'public'.$val['qrcode'],
    	            ROOT_PATH.'public'.$val['wxapp_qrcode'],
    	            $val['createtime']
    	        ];
    	    }
    	    else{
    	        $val['wxapp_qrcode'] = cdnurl($val['wxapp_qrcode']);
    	        $val['qrcode'] = cdnurl($val['qrcode']);
    	    }
    	}
    	unset($val);
    	
    	if($export == 1){
    	    $headArr = ["产品名称","防伪码","H5二维码","小程序二维码","创建时间"];
    	    $result = \app\common\model\PhpOffice::excelExport("product_code-".date("Y-m-d"),$headArr,$export_list,[],[2,3]);
    	}
    	
    	$total = Db::name("bbfx_sverify_product_code")->alias("a")->join("bbfx_sverify_product b","a.product_id=b.id","LEFT")->where($where)->count();
      	
        __success('操作成功',['total'=>$total,'list'=>$list]);
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_sverify_product_code")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'name');
        
      	$res = Db::name("bbfx_sverify_product_code")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("删除产品防伪码","产品防伪码：".implode(",",$titles)."，产品防伪码ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}