<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\turntable_lottery;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Config extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\TurntableLottery;
    }
    
    public function set(){
        $params = $this->param();
        
        $config = Db::name("bbfx_turntable_lottery_activity")->where(["uniacid"=>UNIACID])->find();
        
        $prize = $params['prize'];
        
        $probability_total = 0;
        foreach ($prize as $key => $val){
            $probability = round($val['probability'],2);
             
            if($probability < 0){
                __error("中奖概率不得小于0");
            }
            $probability_total += $probability;
        }
        
        if($probability_total > 100){
            __error("中奖概率加起来不得大于100%");
        }
        
        if($params['prize_type'] == 1){
            if(intval($prize['sales_amount']['total']) < 0){
                __error("请输入平台销售额百分比");
            }
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "status"=>intval($params['status']),
            "rule"=>$params['rule'],
            "image"=>replaceSiteroot($params['image']),
            "starttime"=>$params['starttime'],
            "endtime"=>$params['endtime'],
            "condition_type"=>intval($params['condition_type']),
            "prize_type"=>intval($params['prize_type']),
            "prize"=>iserializer($params['prize']),
        );
        
    	if(!empty($config)){
          	$res = Db::name("bbfx_turntable_lottery_activity")->where(["id"=>$config['id']])->update($data);;
        }
      	else{
        	$res = Db::name("bbfx_turntable_lottery_activity")->insert($data);
        }
        
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_turntable_lottery_activity");
            __success("编辑成功",$data);
        }
      	else{
      	    __success("操作成功",$data);
      	}
    }
}