<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\txabonus;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Config extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Txabonus;
    }
    
    public function recharge(){
        $config = $this->model->getSet();
        $type = $this->param("type/d");
        $money = $this->param("money/f");
        if($money <= 0){
            __error('请输入金额');
        }
        if($type != 1){
            if($money > $config['team_subsidy']){
                __error('扣除的金额不得大于团队补贴');
            }
        }
        
        $data = [
            "uniacid"=>UNIACID,
            "user_id"=>0,
            "money"=>$money,
            "pid"=>0,
            "createtime"=>time()
        ];
        
        try {
            Db::startTrans();
            
            Db::name("bbfx_txabonus_log")->insert($data);
            
            if($type == 1){
                Db::name("bbfx_txabonus")->where(['uniacid'=>UNIACID])->setInc("team_subsidy",$money);
            }
            else{
                Db::name("bbfx_txabonus")->where(['uniacid'=>UNIACID])->setDec("team_subsidy",$money);
            }
            
            Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
            __error($e->getMessage());
        }
        
        __success("操作成功");
    }
    
    public function releaseReward(){
        $result = $this->model->releaseReward();
        __result($result);
    }
    
    public function set(){
        $params = $this->param();
        $config = Db::name("bbfx_txabonus")->where(["uniacid"=>UNIACID])->find();
        
        $data = array(
            "uniacid"=>UNIACID,
            "status"=>intval($params['status']),
            "buy_goods"=>trim($params['buy_goods']),
            "tixian_extract_rate"=>max(0,intval($params['tixian_extract_rate'])),
            // "team_subsidy"=>max(0,intval($params['team_subsidy'])),
            "abonus_num"=>max(0,intval($params['abonus_num'])),
            "consume_money"=>max(0,round($params['consume_money'],2)),
        );
        
        if(!empty($config)){
            $res = Db::name("bbfx_txabonus")->where(["id"=>$config['id']])->update($data);
        }
      	else{
            $res = Db::name("bbfx_txabonus")->insert($data);
        }
        
        if($res){
            
            \app\admin\model\AdminLog::record("","",$data,"bbfx_txabonus");
            
            __success("编辑成功",$data);
        }
      	else{
      	    __success("操作成功",$data);
      	}
    }
    
}