<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\agent;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\Fenxiao;
use app\common\model\bbfxshop\User;


class Agent extends Base
{
    protected $noNeedLogin = ['getAgentUserCheck'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Agent;
    }
    
    public function setRegion(){
        $params = $this->param();
        
        $user = $this->user;
        
        if(!empty($user['agent_province']) || !empty($user['agent_city']) || !empty($user['agent_area'])){
            __error("已设置过代理区域");
        }
        
        $agent_province = $params['agent_province'];
        $agent_city = $params['agent_city'];
        $agent_area = $params['agent_area'];
        $agent_street = $params['agent_street'];
        
        
        $agent_params = ['id'=>''];
        $agent_params['province'] = $agent_province;
        $agent_params['city'] = $agent_city;
        $agent_params['area'] = $agent_area;
        $agent_params['street'] = $agent_street;
        
        $first_log_id = Db::name("bbfx_agent_log")->where(["uniacid"=>UNIACID,'user_id'=>$user['id']])->order("id asc")->value("id");
        if(!empty($first_log_id)){
            $agent_params['id'] = $first_log_id;
        }
        
        $result = $this->model->setRegion($user['id'],$agent_params);
        if($result['code'] == 1){
            __success("设置代理区域成功");
        }
        else{
            __error($result['message']);
        }
    }
    
    public function setUserRegion(){
        global $_W;
        
        if(!empty($this->user['ss_region'])){
            __error("您已经选择了所属区域");
        }
        
        $params = $this->param(['agent_province/s','agent_city/s','agent_area/s','agent_street/s']);
        $agent_province = $params['agent_province'];
        $agent_city = $params['agent_city'];
        $agent_area = $params['agent_area'];
        $agent_street = $params['agent_street'];
        
        $ss_region = $agent_province;
        $level = $_W['base']['agent']['level'];
        if($level >= 2){
            $ss_region .= "-".$agent_city;
        }
        if($level >= 3){
            $ss_region .= "-".$agent_area;
        }
        if($level >= 4){
            // $ss_region .= "-".$agent_street;
        }
        
        $res = Db::name("bbfx_user")->where(['id'=>$this->user['id']])->update(['ss_region'=>$ss_region]);
        if($res){
            __success("设置成功");
        }
        else{
            __error("设置失败");
        }
    } 
    
    public function getAgentUserCheck(){
        $list = [];
        $user = $this->user;
        $where = ["a.uniacid"=>UNIACID,'a.level'=>['>',0],'b.agent_status'=>1];
        
        $agent_log = Db::name("bbfx_agent_log")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where($where)->field("a.*")->select();
        foreach ($agent_log as $key => $val){
            if(empty($val['province'])){
                continue;
            }
            
            if(!empty($user)){
                if($user['agent_status'] == 1 && $user['agent_level'] == 2){
                    if($user['is_deputy_city_agent'] != 1 && $val['level'] == 2){
                        if($val['is_deputy_city_agent'] != 1){
                            continue;
                        }
                        else{
                            $log = Db::name("bbfx_agent_log")->where(['uniacid'=>UNIACID,'level'=>2,'province'=>$val['province'],'city'=>$val['city'],'is_deputy_city_agent'=>0])->find();
                            if(empty($log)){
                                continue;
                            }
                        }
                    }
                    if($user['is_deputy_city_agent'] == 1 && $val['level'] == 2){
                        
                        if($val['is_deputy_city_agent'] != 1){
                            $log = Db::name("bbfx_agent_log")->where(['uniacid'=>UNIACID,'level'=>2,'province'=>$val['province'],'city'=>$val['city'],'is_deputy_city_agent'=>1])->find();
                            if(empty($log)){
                                continue;
                            }
                        }
                        else{
                            continue;
                        }
                        
                    }
                }
            }
            
            $region = [];
            if($val['level'] >= 1){
                $region[] = $val['province'];
            }
            if($val['level'] >= 2){
                if(empty($val['city'])){
                    continue;
                }
                $region[] = $val['city'];
            }
            if($val['level'] >= 3){
                if(empty($val['area'])){
                    continue;
                }
                $region[] = $val['area'];
            }
            if($val['level'] >= 4){
                // if(empty($val['street'])){
                //     continue;
                // }
                // $region[] = $val['street'];
            }
            $regionText = implode("-",$region);
            $list[$regionText] = true;
        }
        
        __success("操作成功",$list);
    }
    
    public function agreementok(){
        $res = Db::name("bbfx_user")->where(['id'=>$this->user['id'],'agent_status'=>1])->update(['is_agent_xyok'=>1]);
        if($res){
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
}