<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\diypage;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Index extends Base
{
    protected $noNeedLogin = ['index','getAccessPermissions'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Diypage;
    }
    
    public function index(){
        $params = $this->param();
        
        $id = $params['id'];
        
        if($id != 'index' && $id != 'member'){
            $access_permissions_levels = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID,'type'=>1,'id'=>intval($id)])->value("access_permissions_levels");
            if(!empty($access_permissions_levels)){
                $levels = iunserializer($access_permissions_levels);
                $user = $this->user;
                $level = intval($user['level']);
                
                if(!empty($levels)){
                    foreach ($levels as $key => &$val){
                        $val = intval($val);
                    }
                    unset($val);
                }
                
                if(!empty($levels) && (!in_array($level,$levels) || $user['is_distributor'] != 1 || $user['distributor_status'] != 1)){
                    __error("无页面访问权限");
                }
            }
        }
        
        $page = $this->model->getPage($id);
        
        if(empty($page)){
            if($id == 'index'){
                __error("未设置默认首页");
            }
            else if($id == 'member'){
                __error("未设置默认个人中心");
            }
            __error("页面不存在");
        }
        
        __success("success",$page);
    }
    
    public function getAccessPermissions(){
        $pages = Db::name("bbfx_diypage")->where(["uniacid"=>UNIACID,'type'=>1,'default_status'=>0])->field("id,access_permissions_levels")->select();
        if(empty($pages)){
            __success("操作成功");
        }
        
        $list = [];
        foreach ($pages as $val) {
            $levels = iunserializer($val['access_permissions_levels']);
            if(!empty($levels)){
                foreach ($levels as $k => &$v){
                    $v = intval($v);
                }
                unset($v);
            }
            $list[$val['id']] = $levels;
        }
        
        __success("操作成功",$list);
    }
}