<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\double_track;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Fenxiao;


class Index extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\DoubleTrack;
    }
    
    public function transferUser(){
        $params = $this->param(['team_user_id/d','to_user_id/d']);
        $result = $this->model->transferUser($params['team_user_id'],$this->user['id'],$params['to_user_id']);
        
        if($result['code'] == 1){
            __success("操作成功");
        }
        else{
            __error($result['message']);
        }
    }
    
    public function getTransferUser(){
        $team_user_id = $this->param('team_user_id/d');
        
        
        $level1_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'is_distributor'=>1,'distributor_status'=>1,'status'=>1,'sup_uid'=>$this->user['id']])->order("become_distributor_time asc")->limit(0,2)->select();
        $uids = [];
        foreach ($level1_user as $key => $val){
            $uids[] = $val['id'];
            $alldown = Fenxiao::getAllDown($val['id']);
            if(!empty($alldown['ids'])){
                $uids = array_merge($uids,$alldown['ids']);
            }
        }
        // print_r($uids);die;
        if(!empty($uids)){
            
            $users = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'is_distributor'=>1,'distributor_status'=>1,'status'=>1,'id'=>['in',$uids]])->field(["id","nickname","avatar","sup_uid","createtime","is_distributor","distributor_status","level",'become_distributor_time'])->select();
            $config = $this->model->getSet();
            
            $num = $config['num'];
            $list = [];
            $levels = Fenxiao::getLevels(1);
            
            
            foreach ($users as $key => $val){
                if($team_user_id == $val['id']){
                    continue;
                }
                $level1_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'is_distributor'=>1,'distributor_status'=>1,'status'=>1,'sup_uid'=>$val['id']])->count();
                if($level1_user < $num){
                    $val['avatar'] = cdnurl($val['avatar']);
                    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
                    $val['become_distributor_time'] = date("Y-m-d H:i:s",$val['become_distributor_time']);
                    if($val['is_distributor'] == 1 && $val['distributor_status'] == 1){
                        $val['levelname'] = $levels[$val['level']]['title'];
                    }
                    
                    $list[] = $val;
                }
            }
            
            if(empty($list)){
                __error("暂时没有可分配用户");
            }
            
            __success('操作成功',$list);
        }
        else{
            __error("暂时没有可分配用户");
        }
    }
}