<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\fenxiao;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Apply extends Base
{
    protected $noNeedLogin = ['getLevel'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Fenxiao;
    }
    
    public function submit(){
        global $_W;
        $set = $_W['base'];
        
        
        $params = $this->paramPost(['realname/s','mobile/s','level/d']);
        if(empty($params['realname'])){
            __error("请填写姓名");
        }
        if(empty($params['mobile'])){
            __error("请填写手机号");
        }
        $level = intval($params['level']);
        $levels = $this->model->getLevels(1);
        if($level == -1){
            $nextLevel = $this->user['nextLevel'];
            if(empty($nextLevel)){
                __error("未开启申请");
            }
            
            if($nextLevel['id'] != 0){
                if($nextLevel['apply'] != 1){
                    __error("该等级暂不支持申请");
                }
            }
            else{
                if($set['fenxiao']['become_agent'] != 4){
                    __error("未开启申请");
                }
            }
            $level = $nextLevel['id'];
        }
        else{
            
            if(empty($levels[$level])){
                __error("申请等级错误");
            }
            
            if($level != 0){
                if($levels[$level]['conditions']['apply'] != 1){
                    __error("该等级暂不支持申请");
                }
            }
            else{
                if($set['fenxiao']['become_agent'] != 4){
                    __error("未开启申请");
                }
            }
        }
        
        if(empty($levels[$level])){
            __error("申请等级错误");
        }
        
        if($this->user['is_distributor'] = 1 && $this->user['distributor_status'] == 1){
            if($levels[$this->user['level']]['sort'] >= $levels[$level]['sort']){
                __error("不可申请低等级");
            }
        }
        
        $up_type = $set['fenxiao']['up_type'];
        if(in_array(14,$up_type) && $set['fenxiao']['user_shenhe_apply'] == 1 && $levels[$level]['id'] != 0){
            $sup_user = Db::name("bbfx_user")->where(['id'=>$this->user['sup_uid'],'is_distributor'=>1,'distributor_status'=>1])->find();
            if(!empty($sup_user)){
                if($levels[$level]['sort'] >= $levels[$sup_user['level']]['sort'] || $levels[$sup_user['level']]['user_shenhe_apply'] != 1){
                    __error("该等级暂不支持申请");
                }
            }
        }
        
        $apply = Db::name("bbfx_fenxiao_apply")->where(["user_id"=>$this->user['id'],'level'=>$level])->find();
        if(!empty($apply)){
            if($apply['status'] == 0){
                __error("您已提交申请，请等待审核");
            }
        }
        
        $data = array(
            'uniacid'=>UNIACID,
            'user_id'=>$this->user['id'],
            'realname'=>$params['realname'],
            'mobile'=>$params['mobile'],
            'status'=>0,
            'level'=>$level,
            'createtime'=>time()
        );
        
        if(!empty($apply)){
            $res = Db::name("bbfx_fenxiao_apply")->where(['id'=>$apply['id']])->update($data);
        }
        else{
            $res = Db::name("bbfx_fenxiao_apply")->insert($data);
        }
        
        if($res){
            __success("提交成功");
        }
        else{
            __error("提交失败");
        }
    }
    
    public function list(){
        global $_W;
        $set = $_W['base'];
        
        $levels = $this->model->getLevels(1);
        $up_type = $set['fenxiao']['up_type'];
        $list = [];
        if(in_array(14,$up_type) && $set['fenxiao']['user_shenhe_apply'] == 1){
            if($levels[$this->user['level']]['user_shenhe_apply'] == 1){
                $user_shenhe_apply = 1;
                $sort = $levels[$this->user['level']]['sort'];
                $level_ids = [];
                foreach ($levels as $key => $val){
                    if($sort > $val['sort']){
                        $level_ids[] = $val['id'];
                    }
                }
                
                $list = Db::name("bbfx_fenxiao_apply")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where(['a.uniacid'=>UNIACID,'b.sup_uid'=>$this->user['id'],'a.status'=>0,'a.level'=>['in',$level_ids]])->field("a.*,b.nickname,b.avatar,b.level as ulevel,b.is_distributor,b.distributor_status")->select();
            }
        }
        
        foreach ($list as $key => &$val){
            $val['avatar'] = cdnurl($val['avatar']);
            $val['apply_levelname'] = $levels[$val['level']]['title'];
            if($val['is_distributor'] == 1 && $val['distributor_status'] == 1){
                $val['levelname'] = $levels[$val['ulevel']]['title'];
            }
            else{
                $val['levelname'] = $set['fenxiao']['texts']['mlevel'];
            }
        }
        unset($val);
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function shenhe(){
        $id = $this->param("id/d");
        $status = $this->param("status/d");
        $apply = Db::name("bbfx_fenxiao_apply")->where(['id'=>$id])->find();
        if(empty($apply)){
            __error("申请不存在");
        }
        
        $apply_user = User::getInfo($apply['user_id']);
        if(empty($apply_user)){
            __error("申请用户不存在");
        }
        
        if($apply_user['sup_uid'] != $this->user['id']){
            __error("无权限操作");
        }
        
        if($status != 1){
            $status = 2;
        }
        
        $res = Db::name("bbfx_fenxiao_apply")->where("id",$apply['id'])->update(['status'=>$status]);
        if($res){
            
            Db::name("bbfx_fenxiao_apply")->where("id",$apply['id'])->update(['sh_user_id'=>$this->user['id']]);
            
            if($status == 1){
                $udata = ['level'=>$apply['level'],'realname'=>$apply['realname'],'mobile'=>$apply['mobile'],'is_distributor'=>1,'distributor_status'=>1];
                
                if($apply['level'] == 0){
                    $udata['become_distributor_time'] = time();
                }
                
                $udata['upgrade_distributor_time'] = time();
                
                $res = Db::name("bbfx_user")->where(['id'=>$apply_user['id']])->update($udata);    
                if($res){
                    $this->model->addUpgradeRecord(2,$apply_user['id'],$udata['level'],$apply_user['level'],$apply_user['sup_uid']);
                }
            }
            
            __success("操作成功");
        }
        else{
            __error("审核失败");
        }
    }
}