<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\fenxiao;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Team extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Fenxiao;
    }
    
    public function index(){
        $user = $this->user;
        
        $down = $this->model->getAllDown($user['id']);
        $team_num = count($down['users']);
        
        $order_count = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'status'=>['>',0],'user_id'=>$user['id']])->count();
        $level1_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'sup_uid'=>$user['id']])->count();
        
        $result = [
            "id"=>$user['id'],
            "nickname"=>$user['nickname'],
            "avatar"=>$user['avatar'],
            "levelname"=>$user['levelname'],
            "team_num"=>$team_num,
            "level1_user"=>$level1_user,
            "order_count"=>$order_count,
            "last_login_time"=>$user['last_login_time'],
            "createtime"=>$user['createtime'],
        ];

        if(is_numeric($result['createtime'])){
            $result['createtime'] = date("Y-m-d H:i:s",$result['createtime']);
        }
        
        __success("操作成功",$result);
    }
    
    public function list(){
        global $_W;
        $params = $this->param();
        $keyword = $params['keyword'];
        $level = intval($params['level']);
        $base = $_W['base'];
        $texts = $base['fenxiao']['texts'];
        $levels = $this->model->getLevels(1);
        
        $user = $this->user;
        
        if($level == 1){
            $where = ["uniacid"=>UNIACID,"sup_uid"=>$user['id']];
            if($base['pyramid']['status'] == 1){
                $where = function($query) use($user){
                    $query->whereOr(function($query) use($user){
                		$query->where(['first_sup_uid'=>0,'sup_uid'=>$user['id']]);
                	});
                	$query->whereOr(function($query) use($user){
                		$query->where(['first_sup_uid'=>$user['id']]);
                	});
                };
            }
            
            $list = Db::name("bbfx_user")->where($where)->where(function($query) use($keyword){
            	$whereOr = [];
            	if(!empty($keyword)){
            	    $whereOr['nickname'] = ['like','%'.$keyword.'%'];
            	    $whereOr['id'] = intval($keyword);
            	}
            	
            	$query->whereOr($whereOr);
            	
            })->field(["id","nickname","avatar","sup_uid","createtime","is_distributor","distributor_status","level",'become_distributor_time'])->order('createtime desc')->select();
            $title = $texts['level1_team'];
        }
        else{
            $type = intval($params['type']);
            $alldown = $this->model->getAllDown($user['id']);
            if($type == 1 || $type == 2){
                if($type == 1){
                    $title = $texts['t4'];
                    $time = strtotime(date("Y-m-d 00:00:00"));
                }
                else{
                    $title = $texts['t5'];
                    $time = strtotime(date("Y-m-01 00:00:00"));
                }
                
                
                $team_list = [];
                
                foreach ($alldown['users'] as $key => $val){
                    if($val['createtime'] > $time){
                        $team_list[] = $val;
                    }
                }
            }   
            else{
                $title = $texts['t6'];
                $team_list = $alldown['users'];
            }
            $list = [];
            if(!empty($team_list)){
                if(!empty($keyword)){
                    foreach ($team_list as $key => $val){
                        if($val['id'] == intval($keyword) || strstr($val['nickname'], $keyword)){
                            $list[] = $val;
                        }
                    }
                }
                else{
                    $list = $team_list;
                }
            }
            
            $createtimes = array_column($list,'createtime');
            array_multisort($createtimes,SORT_DESC,$list);
            
            // $become_distributor_times = array_column($list,'become_distributor_time');
            // array_multisort($become_distributor_times,SORT_DESC,$list);
        }
        
        $start_time = strtotime(date("Y-m-01 00:00:00"));
        $end_time = strtotime(date("Y-m-01 00:00:00",$start_time)." +1 month");
        
        foreach ($list as &$val){
            $val['avatar'] = cdnurl($val['avatar']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['become_distributor_time'] = date("Y-m-d H:i:s",$val['become_distributor_time']);
            $val['levelname'] = "普通用户";
            if($val['is_distributor'] == 1 && $val['distributor_status'] == 1){
                $val['levelname'] = $levels[$val['level']]['title'];
            }
            $alldown = $this->model->getAllDown($val['id']);
            $val['team_num'] = 0;
            if(!empty($alldown['users'])){
                $val['team_num'] = count($alldown['users']);
            }
            // $uids = [];
            // $level_user1 = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'sup_uid'=>$val['id'],'status'=>1])->field("id")->select();
            // if(!empty($level_user1)){
            //     $uids = array_column($level_user1, 'id');
            // }
            // $uids[] = $val['id'];
            
            $alldown = $this->model->getAllDown($val['id']);
            $uids = [];
            if(!empty($alldown)){
                $uids = $alldown['ids'];
            }
            if($config['selfbuy_achievement'] == 1){
                $uids[] = $val['id'];
            }
            $month_achievement = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>['in',$uids],'is_pay'=>1,'createtime'=>['>',$start_time],'refund_status'=>['in',[-1,2]]])->where(['createtime'=>['<',$end_time]])->sum("price");
            
            $val['month_achievement'] = round($month_achievement,2);
            
            $order_count = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'status'=>['>',0],'user_id'=>$val['id']])->count();
            $level1_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'sup_uid'=>$val['id']])->count();
            
            $val['order_count'] = $order_count;
            $val['level1_user'] = $level1_user;
        }
        unset($val);
        
        $is_transfer = 0;
        if($base['double_track']['status'] == 1){
            $num = $base['double_track']['num'];
            $level1_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'is_distributor'=>1,'distributor_status'=>1,'status'=>1,'sup_uid'=>$this->user['id']])->count();
            if($level1_user > $num){
                $is_transfer = 1;
            }
        }
        
        __success("success",array("list"=>$list,"title"=>$title,'is_transfer'=>$is_transfer));
    }
    
    public function getAchievementList(){
        $config = $this->model->getSet();
        $page = max(1,$this->param('page/d'));
        $limit = 5;
        $alldown = $this->model->getAllDown($this->user['id']);
        $list = [];
        if(!empty($alldown)){
            $users = $alldown['users'];
            if(empty($users)) $users = [];
            if($config['selfbuy_achievement'] == 1){
                $users[] = $this->user['id'];
            }
            
            $list = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>['in',$alldown['ids']],'status'=>['in',[1,2,3]],'refund_status'=>-1])->field("id,order_no,user_id,price,createtime")->order("createtime desc")->page($page,$limit)->select();
            foreach ($list as $key => &$val){
                $val['avatar'] = cdnurl($users[$val['user_id']]['avatar']);
                $val['nickname'] = $users[$val['user_id']]['nickname'];
                $order_goods = Db::name("bbfx_order_goods")->where(['uniacid'=>UNIACID,'order_id'=>$val['id']])->field("id,goods_id,total,price,goods_info")->select();
                foreach ($order_goods as $k => &$v){
                    $goods = iunserializer($v['goods_info']);
                    $v['goods_info'] = ['title'=>$goods['title'],'thumb'=>cdnurl($goods['thumb'])];
                }
                unset($v);
                $val['order_goods'] = $order_goods;
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            }
            unset($val);
        }
        
        
        __success("success",["list"=>$list]);
    }
    
}