<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\merchant_admin;

use app\api\controller\merchant_admin\MerchantBase;
use think\Db;
use app\common\model\bbfxshop\Fenxiao;
use app\common\model\bbfxshop\Goods as GoodsModel;

class Goods extends MerchantBase
{
    protected $noNeedLogin = [];
    protected $noMerchantNeedRight = [];
    protected $noNeedRight = ['*'];
    
    public function getList(){
        
        $params = $this->param();
        
        GoodsModel::resetStock(UNIACID);
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        
        $where = ["uniacid"=>UNIACID,'mid'=>$this->mid];
        
        $keyword = trim($params['keyword']);
        $category_id = intval($params['category_id']);
        $status = intval($params['status']);
        if($keyword){
            $where['title'] = ['like','%'.$keyword.'%'];
        }
        
        if($category_id){
            $goods_category = Db::name("bbfx_goods_category")->where("category_id",$category_id)->select();
            $goods_ids = array_column($goods_category,"goods_id");
            $where['id'] = ['in',$goods_ids];
        }
        
        if($status == 1){
            $where['status'] = 1;
            $where['sh_status'] = 1;
        }
        else if($status == 2){
            $where['status'] = 0;
            $where['sh_status'] = 1;
        }
        else if($status == 3){
            $where['sh_status'] = 0;
        }
        else if($status == 4){
            $where['sh_status'] = 2;
        }
        
        
    	$list = Db::name("bbfx_goods")->where($where)->order('sort desc')->field("id,type,title,thumb,stock,sales_volume,price,o_price,sh_status,sh_time,updatetime,createtime")->limit(($pindex - 1) * $psize,$psize)->select();
      	foreach($list as $key => &$val){
      	    
        	$val['thumb'] = cdnurl($val['thumb']);
        	
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    $val['updatetime'] = date("Y-m-d H:i:s",$val['updatetime']);
        	
            $categorys = Db::name("bbfx_goods_category")->alias("a")->join("bbfx_category b","a.category_id=b.id")->where(['a.uniacid'=>UNIACID,'a.goods_id'=>$val['id']])->field('b.id,b.title')->order('b.sort desc')->select();
        	
        	$val['categorys'] = $categorys;
        	
        	$typeText = "";
        	if($val['type'] == 1){
        	    $typeText = "虚拟商品(卡密)";
        	}
        	else if($val['type'] == 2){
        	    $typeText = "实体商品";
        	}
        	else if($val['type'] == 3){
        	    $typeText = "核销商品";
        	}
        	else if($val['type'] == 4){
        	    $typeText = "虚拟商品";
        	}
        	$val['typeText'] = $typeText;
        	
        	if($val['sales_volume'] == 0){
        	    $sales_volume = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","og.order_id=o.id","LEFT")->where(['o.uniacid'=>UNIACID,'o.status'=>['>',0],'og.goods_id'=>$val['id']])->sum("og.total");
        	    $val['sales_volume'] = intval($sales_volume);
        	    
        	    if($val['sales_volume'] > 0){
        	        Db::name("bbfx_goods")->where(['id'=>$val['id']])->update(['sales_volume'=>$val['sales_volume']]);
        	    }
        	}
        }
        unset($al);
    	$total = Db::name("bbfx_goods")->where($where)->count();
    	
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function detail(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $goods = Db::name("bbfx_goods")->where(['id'=>$id,'mid'=>$this->mid])->find();
        $levels = Fenxiao::getLevels();
        
        
        $result = ['levels'=>$levels];
        if(!empty($goods)){
             
            $goods['levels'] = iunserializer($goods['levels']);
            if(empty($goods['levels'])){
                $goods['levels'] = [];
            }
            
            $goods['detail_images'] = cdnurls(iunserializer($goods['detail_images']));
            $goods['slides'] = cdnurls(iunserializer($goods['slides']));
            $goods['videos'] = cdnurls(iunserializer($goods['videos']));
            $goods['thumb'] = cdnurl($goods['thumb']);
            $goods['single_column_thumb'] = cdnurl($goods['single_column_thumb']);
            $goods['authentic_icon'] = cdnurl($goods['authentic_icon']);
            $goods['contract'] = iunserializer($goods['contract']);
            $goods['guarantee'] = iunserializer($goods['guarantee']);
            $goods['share_img'] = cdnurl($goods['share_img']);
            $goods['attr'] = [];
            if($goods['is_recommend'] == 1){
                $goods['attr'][] = 1;
            }
            if($goods['is_new'] == 1){
                $goods['attr'][] = 2;
            }
            if($goods['is_hot'] == 1){
                $goods['attr'][] = 3;
            }
            if($goods['is_nodiscount'] == 1){
                $goods['attr'][] = 4;
            }
            
            $category_ids = [];
            $goods_category = Db::name("bbfx_goods_category")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
            if(!empty($goods_category)){
                $category_ids = array_column($goods_category, 'category_id');
            }
            $goods['category_ids'] = $category_ids;
            $goods['category_id'] = $category_ids[0];
            
            $goods_category = Db::name("bbfx_category")->where(['uniacid'=>UNIACID,'id'=>['in',$category_ids]])->field("id,pid,title")->select();
            if(empty($goods_category)) $goods_category = [];
            $goods_category_ids = [];
            foreach ($goods_category as $key => $val){
                $two = Db::name("bbfx_category")->where(['uniacid'=>UNIACID,'id'=>$val['pid']])->find();
                if(!empty($two)){
                    $three = Db::name("bbfx_category")->where(['uniacid'=>UNIACID,'id'=>$two['pid']])->find();
                    if(!empty($three)){
                        $val['title'] = $three['title']."/".$two['title']."/".$val['title'];
                        $goods_category_ids[] = [$three['id'],$two['id'],$val['id']];
                    }
                    else{
                        $val['title'] = $two['title']."/".$val['title'];
                        $goods_category_ids[] = [$two['id'],$val['id']];
                    }
                }
                else{
                    $goods_category_ids[] = [$val['id']];
                }
            }
            
            $goods['goods_category_ids'] = $goods_category_ids;
            
            $hexiao_store_ids = [];
            $store_goods = Db::name("bbfx_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
            if(!empty($store_goods)){
                $hexiao_store_ids = array_column($store_goods, 'store_id');
            }
            $goods['hexiao_store_ids'] = $hexiao_store_ids;
            
            $goods['commission1'] = iunserializer($goods['commission1']);
            if(empty($goods['commission1'])){
                $goods['commission1'] = [];
            }
            $goods['commission2'] = iunserializer($goods['commission2']);
            if(empty($goods['commission2'])){
                $goods['commission2'] = [];
            }
            $goods['commission3'] = iunserializer($goods['commission3']);
            if(empty($goods['commission3'])){
                $goods['commission3'] = [];
            }
            $goods['jc_reward'] = iunserializer($goods['jc_reward']);
            if(empty($goods['jc_reward'])){
                $goods['jc_reward'] = [];
            }
            $goods['jd_reward'] = iunserializer($goods['jd_reward']);
            if(empty($goods['jd_reward'])){
                $goods['jd_reward'] = [];
            }
            $goods['pj_reward'] = iunserializer($goods['pj_reward']);
            if(empty($goods['pj_reward'])){
                $goods['pj_reward'] = [];
            }
            $goods['ab_reward'] = iunserializer($goods['ab_reward']);
            if(empty($goods['ab_reward'])){
                $goods['ab_reward'] = [];
            }
            $goods['level_discount'] = iunserializer($goods['level_discount']);
            if(empty($goods['level_discount'])){
                $goods['level_discount'] = [];
            }
            $goods['returns'] = iunserializer($goods['returns']);
            if(empty($goods['returns'])){
                $goods['returns'] = ['type'=>0,'day'=>0,'level'=>[],'money1'=>0,'money2'=>0];
            }
            $goods['agent'] = iunserializer($goods['agent']);
            if(empty($goods['agent'])){
                $goods['agent'] = [];
            }
            
            $goods['repurchase_reward1'] = iunserializer($goods['repurchase_reward1']);
            if(empty($goods['repurchase_reward1'])){
                $goods['repurchase_reward1'] = [];
            }
            $goods['repurchase_reward2'] = iunserializer($goods['repurchase_reward2']);
            if(empty($goods['repurchase_reward2'])){
                $goods['repurchase_reward2'] = [];
            }
            $goods['repurchase_reward3'] = iunserializer($goods['repurchase_reward3']);
            if(empty($goods['repurchase_reward3'])){
                $goods['repurchase_reward3'] = [];
            }
            
            $goods['repurchase_pingji_reward'] = iunserializer($goods['repurchase_pingji_reward']);
            if(empty($goods['repurchase_pingji_reward'])){
                $goods['repurchase_pingji_reward'] = [];
            }
            
            $goods['give'] = iunserializer($goods['give']);
            if(empty($goods['give'])){
                $goods['give'] = [];
            }
            
            $goods['cumulative_fanhuan'] = iunserializer($goods['cumulative_fanhuan']);
            if(empty($goods['cumulative_fanhuan'])){
                $goods['cumulative_fanhuan'] = ['level'=>[],'money1'=>'','money2'=>''];
            }
            
            $goods['cloud_warehouse'] = iunserializer($goods['cloud_warehouse']);
            if(empty($goods['cloud_warehouse'])){
                $goods['cloud_warehouse'] = ['level'=>[],'money1'=>'','money2'=>''];
            }
            $goods['cloud_warehouse_chuhuo'] = iunserializer($goods['cloud_warehouse_chuhuo']);
            if(empty($goods['cloud_warehouse_chuhuo'])){
                $goods['cloud_warehouse_chuhuo'] = ['level'=>[],'money1'=>'','money2'=>''];
            }
            
            
            $goods['ladder_push'] = iunserializer($goods['ladder_push']);
            if(empty($goods['ladder_push'])){
                $goods['ladder_push'] = ['level'=>[],'unified'=>[]];
            }
            
            $goods['plugin'] = iunserializer($goods['plugin']);
            if(empty($goods['plugin'])){
                $goods['plugin'] = [];
            }
            
            $commission1 = $goods['commission1'];
            $commission2 = $goods['commission2'];
            $commission3 = $goods['commission3'];
            $repurchase_reward1 = $goods['repurchase_reward1'];
            $repurchase_reward2 = $goods['repurchase_reward2'];
            $repurchase_reward3 = $goods['repurchase_reward3'];
            $jc_reward = $goods['jc_reward'];
            $jd_reward = $goods['jd_reward'];
            $pj_reward = $goods['pj_reward'];
            $ab_reward = $goods['ab_reward'];
            $level_discount = $goods['level_discount'];
            $returns = $goods['returns'];
            $agent = $goods['agent'];
            $give = $goods['give'];
            
            $goods['repurchase_pingji_reward']['money1'] = (array)$goods['repurchase_pingji_reward']['money1'];
            $goods['repurchase_pingji_reward']['money2'] = (array)$goods['repurchase_pingji_reward']['money2'];
            $repurchase_pingji_reward = $goods['repurchase_pingji_reward'];
            $cumulative_fanhuan = $goods['cumulative_fanhuan'];
            $cloud_warehouse = $goods['cloud_warehouse'];
            $cloud_warehouse_chuhuo = $goods['cloud_warehouse_chuhuo'];
            
            $ladder_push = $goods['ladder_push'];
            
            $plugin = $goods['plugin'];
        }
        else{
            $commission1 = [];
            $commission2 = [];
            $commission3 = [];
            $repurchase_reward1 = [];
            $repurchase_reward2 = [];
            $repurchase_reward3 = [];
            $jc_reward = [];
            $jd_reward = [];
            $pj_reward = [];
            $ab_reward = [];
            $repurchase_reward = [];
            $level_discount = [];
            $agent = [];
            $give = [];
            $returns = ['type'=>0,'day'=>0,'level'=>[],'money1'=>0,'money2'=>0];
            $repurchase_pingji_reward = ['money1'=>[],'money2'=>[],'level'=>[]];
            $cumulative_fanhuan = ['level'=>[],'money1'=>'','money2'=>''];
            $cloud_warehouse = ['level'=>[],'money1'=>'','money2'=>''];
            $cloud_warehouse_chuhuo = ['level'=>[],'money1'=>'','money2'=>''];
            
            $ladder_push = ['level'=>[],'unified'=>[]];
            
            $plugin = [];
            
            $goods_category = [];
            $goods_category_ids = [];
        }
        
        if(empty($plugin['coupon'])){
            $plugin['coupon'] = ['is_nouse_coupon'=>0,'give_coupon'=>[]];
        }
        if(empty($plugin['queue_mode'])){
            $plugin['queue_mode'] = ['status'=>0,'rule'=>0,'miandan_total'=>['money1'=>'','money2'=>''],'each_order_rate'=>['money1'=>'','money2'=>'']];
        }
        if(empty($plugin['sabonus'])){
            $plugin['sabonus'] = ['status'=>0,'part'=>''];
        }
        if(empty($plugin['chaoyue'])){
            $plugin['chaoyue'] = ['status'=>1,'inde_rule'=>0,'reward'=>[]];
        }
        if(empty($plugin['pay'])){
            $plugin['pay'] = ['weixin_pay'=>1,'balance_pay'=>1,'deposit_release_pay'=>1];
        }
        
        $grade1 = [];
        $grade2 = [];
        $grade3 = [];
        $grade1_score = [];
        $grade2_score = [];
        $grade3_score = [];
        
        $repurchase_grade1 = [];
        $repurchase_grade2 = [];
        $repurchase_grade3 = [];
        
        $agent_grade1 = [];
        $agent_grade2 = [];
        $agent_grade3 = [];
        $agent_grade4 = [];
        
        $chaoyue_reward = $plugin['chaoyue']['reward'];
        
        foreach ($levels as $key => $val){
            $grade1['level'.$val['id']] = round($commission1['grade']['level'.$val['id']],2);
            $grade2['level'.$val['id']] = round($commission2['grade']['level'.$val['id']],2);
            $grade3['level'.$val['id']] = round($commission3['grade']['level'.$val['id']],2);
            $grade1_score['level'.$val['id']] = round($commission1['grade_score']['level'.$val['id']],2);
            $grade2_score['level'.$val['id']] = round($commission2['grade_score']['level'.$val['id']],2);
            $grade3_score['level'.$val['id']] = round($commission3['grade_score']['level'.$val['id']],2);
            
            $repurchase_grade1['level'.$val['id']] = round($repurchase_reward1['grade']['level'.$val['id']],2);
            $repurchase_grade2['level'.$val['id']] = round($repurchase_reward2['grade']['level'.$val['id']],2);
            $repurchase_grade3['level'.$val['id']] = round($repurchase_reward3['grade']['level'.$val['id']],2);
            
            $jc_reward['level'.$val['id']]['money1'] = round($jc_reward['level'.$val['id']]['money1'],2);
            $jc_reward['level'.$val['id']]['money2'] = round($jc_reward['level'.$val['id']]['money2'],2);
            
            $jd_reward['level'.$val['id']]['money1'] = round($jd_reward['level'.$val['id']]['money1'],2);
            $jd_reward['level'.$val['id']]['money2'] = round($jd_reward['level'.$val['id']]['money2'],2);
            
            $pj_reward['level'.$val['id']]['money1'] = round($pj_reward['level'.$val['id']]['money1'],2);
            $pj_reward['level'.$val['id']]['money2'] = round($pj_reward['level'.$val['id']]['money2'],2);
            
            $ab_reward['level'.$val['id']]['money1'] = round($ab_reward['level'.$val['id']]['money1'],2);
            $ab_reward['level'.$val['id']]['money2'] = round($ab_reward['level'.$val['id']]['money2'],2);
            
            $discount = (int)$level_discount['level'.$val['id']]['money1'];
            $discount_price = (int)$level_discount['level'.$val['id']]['money2'];
            if($discount > 10 || $discount <= 0){
                $discount = 10;
            }
            if($discount_price < 0){
                $discount_price = 0;
            }
             
            $level_discount['level'.$val['id']]['money1'] = $discount;
            $level_discount['level'.$val['id']]['money2'] = $discount_price;
            
            
            $returns['level']['level'.$val['id']]['money1'] = round($returns['level']['level'.$val['id']]['money1'],2);
            $returns['level']['level'.$val['id']]['money2'] = round($returns['level']['level'.$val['id']]['money2'],2);
            
            $agent_grade1['level'.$val['id']]['money1'] = round($agent[1]['grade']['level'.$val['id']]['money1'],2);
            $agent_grade1['level'.$val['id']]['money2'] = round($agent[1]['grade']['level'.$val['id']]['money2'],2);
            
            $agent_grade2['level'.$val['id']]['money1'] = round($agent[2]['grade']['level'.$val['id']]['money1'],2);
            $agent_grade2['level'.$val['id']]['money2'] = round($agent[2]['grade']['level'.$val['id']]['money2'],2);
            
            $agent_grade3['level'.$val['id']]['money1'] = round($agent[3]['grade']['level'.$val['id']]['money1'],2);
            $agent_grade3['level'.$val['id']]['money2'] = round($agent[3]['grade']['level'.$val['id']]['money2'],2);
            
            $agent_grade4['level'.$val['id']]['money1'] = round($agent[4]['grade']['level'.$val['id']]['money1'],2);
            $agent_grade4['level'.$val['id']]['money2'] = round($agent[4]['grade']['level'.$val['id']]['money2'],2);
            
            
            $give['level'.$val['id']]['money1'] = round($give['level'.$val['id']]['money1'],2);
            $give['level'.$val['id']]['money2'] = round($give['level'.$val['id']]['money2'],2);
            
            
            $repurchase_pingji_reward['level']['level'.$val['id']]['money1'] = (array)$repurchase_pingji_reward['level']['level'.$val['id']]['money1'];
            $repurchase_pingji_reward['level']['level'.$val['id']]['money2'] = (array)$repurchase_pingji_reward['level']['level'.$val['id']]['money2'];
            
            $cumulative_fanhuan['level']['level'.$val['id']]['money1'] = round($cumulative_fanhuan['level']['level'.$val['id']]['money1'],2);
            $cumulative_fanhuan['level']['level'.$val['id']]['money2'] = round($cumulative_fanhuan['level']['level'.$val['id']]['money2'],2);
            
            $cloud_warehouse['level']['level'.$val['id']]['money1'] = round($cloud_warehouse['level']['level'.$val['id']]['money1'],2);
            $cloud_warehouse['level']['level'.$val['id']]['money2'] = round($cloud_warehouse['level']['level'.$val['id']]['money2'],2);
            
            $cloud_warehouse_chuhuo['level']['level'.$val['id']]['money1'] = round($cloud_warehouse_chuhuo['level']['level'.$val['id']]['money1'],2);
            $cloud_warehouse_chuhuo['level']['level'.$val['id']]['money2'] = round($cloud_warehouse_chuhuo['level']['level'.$val['id']]['money2'],2);
            
            $ladder_push['level']['level'.$val['id']] = (array)$ladder_push['level']['level'.$val['id']];
            
            
            $chaoyue_reward['level'.$val['id']]['money1'] = round($chaoyue_reward['level'.$val['id']]['money1'],2);
            $chaoyue_reward['level'.$val['id']]['money2'] = round($chaoyue_reward['level'.$val['id']]['money2'],2);
            
        }
        if(empty($commission1)){
            $commission1 = ['level'=>['money1'=>'','money2'=>'','money1_score'=>'','money2_score'=>''],'grade'=>$grade1,'grade_score'=>$grade1_score];
        }
        else{
            $commission1['grade'] = $grade1;
            $commission1['grade_score'] = $grade1_score;
        }
        if(empty($commission2)){
            $commission2 = ['level'=>['money1'=>'','money2'=>'','money1_score'=>'','money2_score'=>''],'grade'=>$grade2,'grade_score'=>$grade2_score];
        }
        else{
            $commission2['grade'] = $grade2;
            $commission2['grade_score'] = $grade2_score;
        }
        if(empty($commission3)){
            $commission3 = ['level'=>['money1'=>'','money2'=>'','money1_score'=>'','money2_score'=>''],'grade'=>$grade3,'grade_score'=>$grade3_score];
        }
        else{
            $commission3['grade'] = $grade3;
            $commission3['grade_score'] = $grade3_score;
        }
        
        if(empty($repurchase_reward1)){
            $repurchase_reward1 = ['level'=>['money1'=>'','money2'=>''],'grade'=>$repurchase_grade1];
        }
        else{
            $repurchase_reward1['grade'] = $repurchase_grade1;
        }
        if(empty($repurchase_reward2)){
            $repurchase_reward2 = ['level'=>['money1'=>'','money2'=>''],'grade'=>$repurchase_grade2];
        }
        else{
            $repurchase_reward2['grade'] = $repurchase_grade2;
        }
        if(empty($repurchase_reward3)){
            $repurchase_reward3 = ['level'=>['money1'=>'','money2'=>''],'grade'=>$repurchase_grade3];
        }
        else{
            $repurchase_reward3['grade'] = $repurchase_grade3;
        }
        
        $plugin['chaoyue']['reward'] = $chaoyue_reward;
        
        if(empty($agent)){
            $agent = array(
                "1"=>array(
                    'level'=>['money1'=>'','money2'=>''],
                    'grade'=>$agent_grade1
                ),
                "2"=>array(
                    'level'=>['money1'=>'','money2'=>''],
                    'grade'=>$agent_grade2
                ),
                "3"=>array(
                    'level'=>['money1'=>'','money2'=>''],
                    'grade'=>$agent_grade3
                ),
                "4"=>array(
                    'level'=>['money1'=>'','money2'=>''],
                    'grade'=>$agent_grade4
                ),
            );
        }
        else{
            $agent[1]['grade'] = $agent_grade1;
            $agent[2]['grade'] = $agent_grade2;
            $agent[3]['grade'] = $agent_grade3;
            $agent[4]['grade'] = $agent_grade4;
        }
        
        
        
        
        
        if(!empty($goods)){
            $goods['plugin'] = $plugin;
            
            
            $goods['commission1'] = $commission1;
            $goods['commission2'] = $commission2;
            $goods['commission3'] = $commission3;
            
            $goods['jc_reward'] = $jc_reward;
            $goods['jd_reward'] = $jd_reward;
            $goods['pj_reward'] = $pj_reward;
            $goods['ab_reward'] = $ab_reward;
            
            $goods['repurchase_reward1'] = $repurchase_reward1;
            $goods['repurchase_reward2'] = $repurchase_reward2;
            $goods['repurchase_reward3'] = $repurchase_reward3;
            
            $goods['cumulative_fanhuan'] = $cumulative_fanhuan;
            $goods['cloud_warehouse'] = $cloud_warehouse;
            $goods['cloud_warehouse_chuhuo'] = $cloud_warehouse_chuhuo;
            
            $goods['ladder_push'] = $ladder_push;
            
            $goods['level_discount'] = $level_discount;
            
            $goods['returns'] = $returns;
            
            $goods['agent'] = $agent;
            $goods['give'] = $give;
            $goods['repurchase_pingji_reward'] = $repurchase_pingji_reward;
            
            $spec = Db::name("bbfx_goods_spec")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->field("id,name")->order("id asc")->select();
            $spec_item_list = [];
            if(!empty($spec)){
                foreach ($spec as $key => &$val){
                    $spec_items = Db::name("bbfx_goods_spec_item")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id'],'pid'=>$val['id']])->field("id,name")->select();
                    foreach ($spec_items as $k => &$v){
                        $v['pindex'] = $key;
                        $v['index'] = $k;
                        $spec_item_list[$v['id']] = $key."_".$k;
                    }
                    unset($v);
                    $val['spec_item'] = $spec_items;
                }
                unset($val);
                
                $sku_list = Db::name("bbfx_goods_spec_sku")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->field(['price','profit_amount','original_price','stock','thumb','sku','id'])->select();
                $sku_data = [];
                foreach ($sku_list as $key => $val){
                    $sku = explode(",",$val['sku']);
                    $sku_key = [];
                    foreach ($sku as $k => $v){
                        
                        $sku_key[] = $spec_item_list[$v];
                    }
                    $sku_key = implode(",",$sku_key);
                    $sku_data['price'][$sku_key] = $val['price']; 
                    $sku_data['profit_amount'][$sku_key] = $val['profit_amount']; 
                    $sku_data['original_price'][$sku_key] = $val['original_price'];
                    $sku_data['stock'][$sku_key] = $val['stock'];
                    $sku_data['thumb'][$sku_key] = cdnurl($val['thumb']);
                }
                $goods['sku_data'] = $sku_data;
            }
            else{
                $goods['is_spec'] = 0;
            }
            
            $goods['spec'] = $spec;
            
            $result['goods'] = $goods;
        }
        $result['plugin'] = $plugin;
        
        $result['commission1'] = $commission1;
        $result['commission2'] = $commission2;
        $result['commission3'] = $commission3;
        
        $result['jc_reward'] = $jc_reward;
        $result['jd_reward'] = $jd_reward;
        $result['pj_reward'] = $pj_reward;
        $result['ab_reward'] = $ab_reward;
        $result['repurchase_reward1'] = $repurchase_reward1;
        $result['repurchase_reward2'] = $repurchase_reward2;
        $result['repurchase_reward3'] = $repurchase_reward3;
        $result['level_discount'] = $level_discount;
        $result['returns'] = $returns;
        $result['agent'] = $agent;
        $result['give'] = $give;
        $result['repurchase_pingji_reward'] = $repurchase_pingji_reward;
        $result['cumulative_fanhuan'] = $cumulative_fanhuan;
        $result['cloud_warehouse'] = $cloud_warehouse;
        $result['cloud_warehouse_chuhuo'] = $cloud_warehouse_chuhuo;
        
        $result['ladder_push'] = $ladder_push;
        $contract_list = Db::name("bbfx_contract")->where(['uniacid'=>UNIACID,'type'=>1])->field("id,name")->select();
        $result['contract_list'] = $contract_list;
        
        $coupon_list = Db::name("bbfx_coupon")->where(['uniacid'=>UNIACID,'status'=>1])->select();
        $result['coupon_list'] = $coupon_list;
        
        $result['goods_category'] = $goods_category;
        __success("操作成功",$result);
    }
    
    public function post(){
        $params = $this->param(['id/d','title/s','thumb/s','type/d','price/f','is_hexiao_quantity/d','o_price/f','content/s','subtitle/s','express_fee/f','profit_amount/f','stock_type/d','minbuy/d','maxbuy/d','daily_buy/d','monthly_buy/d','total_maxbuy/d','is_give/d','give_type/d','give/a','levels/a','is_contract/d','contract/a','guarantee/a','fastest_delivery/d','arrive_day/d','express_name/s','vip_free_shipping/d','is_authentic/d','authentic_name/s','authentic_desc/s','status/d','single_column_thumb/s','authentic_icon/s','stock/d','is_spec/d','delivery_method/d','virtual_sale/d','plugin/a','is_hexiao/d','hexiao_num/d','hexiao_store_type/d','hexiao_store_ids/a','is_fenxiao/d','commission_rule/d','commission1/a','commission2/a','commission3/a','is_repurchase_rule/d','repurchase_reward1/a','repurchase_reward2/a','repurchase_reward3/a','is_jicha_rule/d','is_jiandan_rule/d','is_pingji_rule/d','is_abonus_rule/d','is_abonus/d','upgrade_score/d','is_leveldiscount_rule/d','is_agent/d','agent_rule/d','jc_reward/a','jd_reward/a','pj_reward/a','ab_reward/a','is_repurchase/d','is_repurchase_pingji/d','is_repurchase_pingji_rule/d','repurchase_pingji_reward/a','level_discount/a','returns/a','agent/a','is_cumulative_fanhuan/d','cumulative_fanhuan_rule/d','cumulative_fanhuan/a','cloud_warehouse_rule/d','cloud_warehouse/a','cloud_warehouse_chuhuo/a','is_return/d','is_return_rule/d','is_ladder_push/d','is_ladder_push_loop/d','ladder_push_rule/d','ladder_push/a','attr/a','share_title/s','share_img/s','spec/a','slides/a','videos/a','category_id/d','sku_list/a']);
        
        $id = intval($params['id']);
        
        $goods = Db::name("bbfx_goods")->where(['id'=>$id,'mid'=>$this->mid])->find();
        
        $msg = "";
      	$sort = intval($params['sort']);
      	if(empty($params['title'])){
        	$msg = "请填写商品名称";
        }
      	if(empty($params['thumb'])){
        	$msg = "请上传商品图片";
        }
      
      	if($msg){
        	__error($msg);
        }
        $type = max(1,intval($params['type']));
        
        if(!empty($goods)){
            $type = $goods['type'];
        }
        
        $price = floatval($params['price']);
        $o_price = floatval($params['o_price']);
        $content = htmlspecialchars_decode($params['content']); 
        
    	$data = array(
        	"uniacid"=>UNIACID,
        	"mid"=>$this->mid,
          	"title"=>$params['title'],
          	"subtitle"=>$params['subtitle'],
          	"thumb"=>$params['thumb'],
          	"price"=>$price,
          	"o_price"=>$o_price,
          	"express_fee"=>floatval($params['express_fee']),
          	"profit_amount"=>floatval($params['profit_amount']),
          	"stock_type"=>intval($params['stock_type']),
          	"minbuy"=>max(1,intval($params['minbuy'])),
          	"maxbuy"=>intval($params['maxbuy']),
          	"daily_buy"=>intval($params['daily_buy']),
          	"monthly_buy"=>intval($params['monthly_buy']),
          	"total_maxbuy"=>intval($params['total_maxbuy']), 
          	"is_give"=>intval($params['is_give']),
          	"give_type"=>intval($params['give_type']),
          	"give"=>iserializer($params['give']),
          	"levels"=>iserializer($params['levels']),
          	"is_contract"=>intval($params['is_contract']),
          	"contract"=>iserializer($params['contract']),
          	"guarantee"=>iserializer($params['guarantee']),
          	"fastest_delivery"=>intval($params['fastest_delivery']),
          	"arrive_day"=>intval($params['arrive_day']),
          	"express_name"=>$params['express_name'],
          	"vip_free_shipping"=>intval($params['vip_free_shipping']),
          	"is_authentic"=>intval($params['is_authentic']),
          	"authentic_name"=>$params['authentic_name'],
          	"authentic_desc"=>$params['authentic_desc'],
          	"status"=>$params['status'],
          	"single_column_thumb"=>replaceSiteroot($params['single_column_thumb']),
          	"authentic_icon"=>replaceSiteroot($params['authentic_icon']),
          	"content"=>$content,
          	"sort"=>$sort,
          	"is_recommend"=>0,
          	"is_new"=>0,
          	"is_hot"=>0,
          	"is_nodiscount"=>0,
          	"stock"=>intval($params['stock']),
          	"is_spec"=>intval($params['is_spec']),
          	"delivery_method"=>intval($params['delivery_method']),
          	"virtual_sale"=>intval($params['virtual_sale']),
          	"plugin"=>iserializer($params['plugin']),
          	"is_hexiao_quantity"=>intval($params['is_hexiao_quantity']),
          	"updatetime"=>time()
        );
        
        if($type == 2 && ($params['delivery_method'] == 2 || $params['delivery_method'] == 3) || ($type == 4 && intval($params['is_hexiao']) == 1)){
            $data['is_hexiao'] = 1;
            $data['hexiao_num'] = max(1,intval($params['hexiao_num']));
            $data['hexiao_store_type'] = intval($params['hexiao_store_type']);
            if($params['hexiao_store_type'] == 1 && empty($params['hexiao_store_ids'])){
                __error("请选择核销门店");
            }
        }
        else{
            $data['is_hexiao'] = 0;
        }
        
        
        
        // 分销配置
        $data['is_fenxiao'] = intval($params['is_fenxiao']);
        $data['commission_rule'] = intval($params['commission_rule']);
        $data['commission1'] = iserializer($params['commission1']);
        $data['commission2'] = iserializer($params['commission2']);
        $data['commission3'] = iserializer($params['commission3']);
        $data['is_repurchase_rule'] = intval($params['is_repurchase_rule']);
        $data['repurchase_reward1'] = iserializer($params['repurchase_reward1']);
        $data['repurchase_reward2'] = iserializer($params['repurchase_reward2']);
        $data['repurchase_reward3'] = iserializer($params['repurchase_reward3']);
        $data['is_jicha_rule'] = intval($params['is_jicha_rule']);
        $data['is_jiandan_rule'] = intval($params['is_jiandan_rule']);
        $data['is_pingji_rule'] = intval($params['is_pingji_rule']);
        $data['is_abonus_rule'] = intval($params['is_abonus_rule']);
        $data['is_abonus'] = intval($params['is_abonus']);
        $data['upgrade_score'] = intval($params['upgrade_score']);
        $data['is_leveldiscount_rule'] = intval($params['is_leveldiscount_rule']);
        $data['is_return'] = intval($params['is_return']);
        $data['is_return_rule'] = intval($params['is_return_rule']);
        $data['is_agent'] = intval($params['is_agent']);
        $data['agent_rule'] = intval($params['agent_rule']);
        $data['jc_reward'] = iserializer($params['jc_reward']);
        $data['jd_reward'] = iserializer($params['jd_reward']);
        $data['pj_reward'] = iserializer($params['pj_reward']);
        $data['ab_reward'] = iserializer($params['ab_reward']);
        
        
        
        $data['is_repurchase'] = (int)$params['is_repurchase'];
        $data['is_repurchase_pingji'] = (int)$params['is_repurchase_pingji'];
        $data['is_repurchase_pingji_rule'] = (int)$params['is_repurchase_pingji_rule'];
        $data['repurchase_pingji_reward'] = iserializer($params['repurchase_pingji_reward']);
        
        $level_discount = $params['level_discount'];
        $data['level_discount'] = iserializer($level_discount);
        $data['returns'] = iserializer($params['returns']);
        
        $data['agent'] = iserializer($params['agent']);
        
        $data['is_cumulative_fanhuan'] = (int)$params['is_cumulative_fanhuan'];
        $data['cumulative_fanhuan_rule'] = (int)$params['cumulative_fanhuan_rule'];
        $data['cumulative_fanhuan'] = iserializer($params['cumulative_fanhuan']);
        
        $data['cloud_warehouse_rule'] = (int)$params['cloud_warehouse_rule'];
        $data['cloud_warehouse'] = iserializer($params['cloud_warehouse']);
        $data['cloud_warehouse_chuhuo'] = iserializer($params['cloud_warehouse_chuhuo']);
        
        
        $data['is_ladder_push'] = (int)$params['is_ladder_push'];
        $data['is_ladder_push_loop'] = (int)$params['is_ladder_push_loop'];
        $data['ladder_push_rule'] = (int)$params['ladder_push_rule'];
        $data['ladder_push'] = iserializer($params['ladder_push']);
        
        
        
        $attr = $params['attr'];
        if(in_array(1,$attr)){
            $data['is_recommend'] = 1;
        }
        if(in_array(2,$attr)){
            $data['is_new'] = 1;
        }
        if(in_array(3,$attr)){
            $data['is_hot'] = 1;
        }
        if(in_array(4,$attr)){
            $data['is_nodiscount'] = 1;
        }
        
        
        $data['share_title'] = $params['share_title'];
        $data['share_img'] = $params['share_img'];
        
        
        $data['detail_images'] = iserializer(replaceSiteroots($params['detail_images']));
        $data["slides"] = iserializer(replaceSiteroots($params['slides']));
        $data["videos"] = iserializer(replaceSiteroots($params['videos']));
        $data['share_img'] = replaceSiteroot($data['share_img']);
        $data['thumb'] = replaceSiteroot($data['thumb']);
        
        $spec_list = $params['spec'];
        if(empty($spec_list)){
            $data['is_spec'] = 0;
        }
        
        if($type == 1 && ($type == 2 && $data['is_spec'] == 1)){
            unset($data['stock']);
        }
        
        $config = $this->model->getSet();
        
        if(!empty($goods)){
            if($goods['sh_status'] == 2 || $config['edit_goods_shenhe'] == 1){
                $sh_status = 0;
            }
            else{
                $sh_status = $goods['sh_status'];
            }
            
            if($config['goods_shenhe'] != 1){
                // $sh_status = 1;
            }
        }
        else{
            if($config['goods_shenhe'] == 1){
                $sh_status = 0;
            }
            else{
                $sh_status = 1;
            }
        }
        $data['sh_status'] = $sh_status;
        
        if($sh_status == 1){
            $data['sh_time'] = time();
        }
        
        // echo "<pre>";
        // print_r($data);die;
      	if(!empty($goods)){
            $res = Db::name("bbfx_goods")->where(["id"=>$goods['id']])->update($data);
        }
      	else{
      	    $data['type'] = $type;
          	$data['createtime'] = time();
          	
            $id = Db::name("bbfx_goods")->insertGetId($data);
            $res = $id;
        }
        
        
        
        if($id){
            $data['id'] = $id;
            $res = true;
            $category_ids = $params['category_ids'];
            $category_ids = [$params['category_id']];
            $categorys = Db::name("bbfx_goods_category")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
            $categorys = array_skey($categorys,'category_id');
            $c_ids = [];
            // $goods_category_ids = $params['goods_category_ids'];
            // $category_ids = [];
            // foreach ($goods_category_ids as $key => $val){
            //     $category_ids[] = $val[count($val)-1];
            // }
            
            if(!empty($category_ids)){
                foreach ($category_ids as $key => $val){
                    $c_ids[$val] = true;
                    if(!empty($val) && empty($categorys[$val])){
                        Db::name("bbfx_goods_category")->insert(['uniacid'=>UNIACID,'goods_id'=>$id,'category_id'=>$val]);
                    }
                }
            }
            foreach ($categorys as $key => $val){
                if(empty($c_ids[$val['category_id']])){
                    Db::name("bbfx_goods_category")->where(['id'=>$val['id']])->delete();
                }
            }
            
            
            if($data['is_hexiao'] == 1){
                $hexiao_store_ids = $params['hexiao_store_ids'];
                $store_goods = Db::name("bbfx_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
                $store_goods = array_skey($store_goods,'store_id');
                $s_ids = [];
                if(!empty($hexiao_store_ids)){
                    foreach ($hexiao_store_ids as $key => $val){
                        $s_ids[$val] = true;
                        if(empty($store_goods[$val])){
                            Db::name("bbfx_store_goods")->insert(['uniacid'=>UNIACID,'goods_id'=>$id,'store_id'=>$val]);
                        }
                    }
                }
                foreach ($store_goods as $key => $val){
                    if(empty($s_ids[$val['store_id']])){
                        Db::name("bbfx_store_goods")->where(['id'=>$val['id']])->delete();
                    }
                }
                
            }
            
            if($data['is_spec'] == 1){
                $spec_item_ids = [];
                $spec_all = Db::name("bbfx_goods_spec")->where(['uniacid'=>UNIACID,'goods_id'=>$id])->select();
                $spec_item_all = Db::name("bbfx_goods_spec_item")->where(['uniacid'=>UNIACID,'goods_id'=>$id])->select();
                $spec_ok = [];
                $spec_item_ok = [];
                
                foreach($spec_list as $key => &$val){
                    $goods_spec = array(
                        "uniacid"=>UNIACID,
                        "goods_id"=>$id,
                        "name"=>$val['name']
                    );
                    $spec_id = intval($val['id']);
                    if($spec_id > 0){
                        Db::name("bbfx_goods_spec")->where(['id'=>$spec_id])->update($goods_spec);
                    }
                    else{
                        $spec_id = Db::name("bbfx_goods_spec")->insertGetId($goods_spec);
                    }
                    
                    $spec_ok[$spec_id] = true;
                    
                    foreach ($val['spec_item'] as $k => $v){
                        $goods_spec_item = array(
                            "uniacid"=>UNIACID,
                            "goods_id"=>$id,
                            "pid"=>$spec_id,
                            "name"=>$v['name']
                        );
                        $spec_item_id = intval($v['id']);
                        if($spec_item_id > 0){
                            Db::name("bbfx_goods_spec_item")->where(['id'=>$spec_item_id])->update($goods_spec_item);
                        }
                        else{
                            $spec_item_id = Db::name("bbfx_goods_spec_item")->insertGetId($goods_spec_item);
                        }
                        $spec_item_ok[$spec_item_id] = true;
                        $spec_item_ids[$key."_".$k] = $spec_item_id;
                        $val['spec_item'][$k]['id'] = $spec_item_id;
                    }
                }
                unset($val);
                
                foreach ($spec_all as $key => $val){
                    if(empty($spec_ok[$val['id']])){
                        Db::name("bbfx_goods_spec")->where(['id'=>$val['id']])->delete();
                    }
                }
                foreach ($spec_item_all as $key => $val){
                    if(empty($spec_item_ok[$val['id']])){
                        Db::name("bbfx_goods_spec_item")->where(['id'=>$val['id']])->delete();
                    }
                }
                
                
                $sku_list = $params['sku_list'];
                
                $spec_sku_all = Db::name("bbfx_goods_spec_sku")->where(['uniacid'=>UNIACID,'goods_id'=>$id])->select();
                $spec_sku_list = array_skey($spec_sku_all,"id");
                $spec_sku_all = array_skey($spec_sku_all,"sku");
                $spec_sku_ok = [];
                foreach ($sku_list as $key => $val){
                    $specs = $val['spec'];
                    $sku = [];
                    $sku_name = [];
                    foreach ($specs as $k => $v){
                        $spec_id = $spec_item_ids[$v['pindex']."_".$v['index']];
                        // print_r($v['pindex']."_".$v['index']);die;
                        if(empty($spec_id)){
                            $sku = [];
                            break;
                        }
                        $sku[] = $spec_id;
                        $sku_name[] = $v['name'];
                    }
                    $sku = implode(",",$sku);
                    $spec_sku_id = intval($spec_sku_all[$sku]['id']);
                    $sku_name = implode(",",$sku_name);
                    $thumb = replaceSiteroot($val['thumb']);
                    $spec_sku = array(
                        "uniacid"=>UNIACID,
                        "goods_id"=>$id,
                        "sku"=>$sku,
                        "sku_name"=>$sku_name,
                        "price"=>floatval($val['price']),
                        "profit_amount"=>floatval($val['profit_amount']),
                        "original_price"=>floatval($val['original_price']),
                        "stock"=>intval($val['stock']),
                        "thumb"=>$thumb
                    );
                    if($spec_sku_id > 0){
                        Db::name("bbfx_goods_spec_sku")->where(['id'=>$spec_sku_id])->update($spec_sku);
                    }
                    else{
                        $spec_sku_id = Db::name("bbfx_goods_spec_sku")->insertGetId($spec_sku);
                    }
                    $spec_sku_ok[$spec_sku_id] = true;
                }
                foreach ($spec_sku_list as $key => $val){
                    if(empty($spec_sku_ok[$val['id']])){
                        Db::name("bbfx_goods_spec_sku")->where(['id'=>$val['id']])->delete();
                    }
                }
            }
             
            GoodsModel::resetStock(UNIACID,$id);
        }
        if(empty($res)){
            __error("操作失败",$data);
        }
        
      	__success("编辑成功");
        
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
        $list = Db::name("bbfx_goods")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'title');
        
      	$res = Db::name("bbfx_goods")->where('id','in',$ids)->delete();
      	if($res){
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}