<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\merchant_admin;

use app\api\controller\merchant_admin\MerchantBase;
use think\Db;


class Merchant extends MerchantBase
{
    protected $noNeedLogin = [];
    protected $noMerchantNeedRight = ['apply'];
    protected $noNeedRight = ['*'];
    
    protected function editInfo(){
        
        $params = $this->paramPost(['name/s','logo/s','realname/s','mobile/s','region/a','address/s','lng/f','lat/f','yy_status/d','yy_time/s','commission_rate/f','content/s','images/a','detail_images/a','introduction/s','is_fenxiao/d']);
        
        if(empty($params['name'])){
            __error("请输入门店名称");
        }
        if(empty($params['mobile'])){
            __error("请输入联系电话");
        }
        if(empty($params['region'])){
            __error("请选择门店区域");
        }
        if(empty($params['lng']) || empty($params['lng'])){
            __error("请在地图中选择门店地址");
        }
        if(empty($params['yy_time'])){
            __error("请输入营业时间");
        }
        if($params['commission_rate'] > 100){
            __error("分润佣金比例不可大于100%");
        }
        
        $user = $this->user;
        $item = Db::name("bbfx_merchant")->where(['user_id'=>$user['id']])->find();
        
        $sh_data = array(
            "uniacid"=>UNIACID,
            "is_fenxiao"=>$params['is_fenxiao'],
            "name"=>$params['name'],
            "logo"=>replaceSiteroot($params['logo']),
            "realname"=>$params['realname'],
            "mobile"=>$params['mobile'],
            "yy_time"=>$params['yy_time'],
            "province"=>$params['region'][0],
            "city"=>$params['region'][1],
            "area"=>$params['region'][2],
            "address"=>$params['address'],
            "lng"=>$params['lng'],
            "lat"=>$params['lat'],
            "content"=>$params['content'],
            "yy_status"=>$params['yy_status'],
            "introduction"=>$params['introduction'],
            "commission_rate"=>$params['commission_rate'],
            "images"=>iserializer(replaceSiteroots($params['images'])),
            "detail_images"=>iserializer(replaceSiteroots($params['detail_images'])),
        );
        $config = $this->model->getSet();
        if(!empty($item)){
            if($item['sh_status'] == 2 || $config['edit_shenhe'] == 1){
                $sh_status = 0;
            }
            else{
                $sh_status = $item['sh_status'];
            }
            
            if($config['apply_shenhe'] != 1){
                // $sh_status = 1;
            }
        }
        else{
            if($config['apply_shenhe'] == 1){
                $sh_status = 0;
            }
            else{
                $sh_status = 1;
            }
        }
        
        if($sh_status === 0 && !empty($item)){
            $data['sh_status'] = $sh_status;
            $data['updatetime'] = time();
            $data['sh_data']= iserializer($sh_data);
        }
        else{
            $data = $sh_data;
            $data['user_id'] = $user['id'];
            $data['updatetime'] = time();
            $data['createtime'] = time();
            $data['sh_status'] = $sh_status;
        }
        if($sh_status == 1){
            $data['sh_time'] = time();
            $data['is_shenhe'] = 1;
        }
        
        if($config['status'] != 1){
            __error("商户功能未开启");
        }
        if($config['apply_status'] != 1){
            __error("商户申请功能未开启");
        }
        
        if(!empty($item)){
            $res = Db::name("bbfx_merchant")->where(["id"=>$item['id']])->update($data);
            $id = $item['id'];
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_merchant")->insertGetId($data);
            $id = $res;
        }
        
        if($res){
            
            if($data['sh_status'] === 0){
                __success("提交成功，请等待审核");
            }
            else{
                $this->model->syncMainStore($id);
                __success("提交成功");
            }
            
        }
        else{
            __error("提交失败");
        }
    }
    
    public function apply(){
        $this->editInfo();
    }
    
    public function edit(){
        $this->editInfo();
    }
    
    public function info(){
        
        $info = $this->model->getInfo($this->merchant['id']);
        
        $where = ['uniacid'=>UNIACID,'mid'=>$this->mid];
        $month_time = strtotime(date("Y-m-01 00:00:00"));
        $time = strtotime(date("Y-m-d 00:00:00"));
        $order_count = Db::name("bbfx_order")->where($where)->count();
        $order_price = Db::name("bbfx_order")->where($where)->where(['is_pay'=>1,'refund_status'=>['in',[-1,2]]])->sum("price");
        $order_count_month = Db::name("bbfx_order")->where($where)->where(['createtime'=>['>',$month_time]])->count();
        $order_price_month = Db::name("bbfx_order")->where($where)->where(['createtime'=>['>',$month_time],'is_pay'=>1,'refund_status'=>['in',[-1,2]]])->sum("price");
        $order_count_today = Db::name("bbfx_order")->where($where)->where(['createtime'=>['>',$time]])->count();
        $order_price_today = Db::name("bbfx_order")->where($where)->where(['createtime'=>['>',$time],'is_pay'=>1,'refund_status'=>['in',[-1,2]]])->sum("price");
        
        $where1 = ['uniacid'=>UNIACID,'withdrawal_type'=>7,'user_id'=>$this->mid,'status'=>['in',[0,1]]];
        $withdrawal_money = Db::name("bbfx_withdrawal_log")->where($where1)->sum("money");
        $withdrawal_money_month = Db::name("bbfx_withdrawal_log")->where($where1)->where(['createtime'=>['>',$month_time]])->sum("money");
        $withdrawal_money_today = Db::name("bbfx_withdrawal_log")->where($where1)->where(['createtime'=>['>',$time]])->sum("money");
        
        $statistics = [
            [
                'order_count'=>intval($order_count_today),
                'order_price'=>round($order_price_today,2),
                'balance'=>$this->merchant['balance'],
                'withdrawal_money'=>round($withdrawal_money_today,2),
            ],
            [
                'order_count'=>intval($order_count_month),
                'order_price'=>round($order_price_month,2),
                'balance'=>$this->merchant['balance'],
                'withdrawal_money'=>round($withdrawal_money_month,2),
            ],
            [
                'order_count'=>intval($order_count),
                'order_price'=>round($order_price,2),
                'balance'=>$this->merchant['balance'],
                'withdrawal_money'=>round($withdrawal_money,2),
            ],
        ];
        
        $count0 = Db::name("bbfx_order")->where($where)->where(['is_pay'=>0,'status'=>0])->count();
        $count1 = Db::name("bbfx_order")->where($where)->where(['is_pay'=>1,'status'=>1,'refund_status'=>['in',[-1,2]]])->count();
        $count2 = Db::name("bbfx_order")->where($where)->where(['is_pay'=>1,'status'=>2,'refund_status'=>['in',[-1,2]]])->count();
        $count3 = Db::name("bbfx_order")->where($where)->where(['is_pay'=>1,'status'=>3,'refund_status'=>['in',[-1,2]]])->count();
        $count4 = Db::name("bbfx_order")->where($where)->where(['is_pay'=>1,'status'=>['in',[1,2,3]],'refund_status'=>['in',[0,1]]])->count();
        
        $order_count = ['count0'=>intval($count0),'count1'=>intval($count1),'count2'=>intval($count2),'count3'=>intval($count3),'count4'=>intval($count4)];
        
        __success("操作成功",['info'=>$info,'statistics'=>$statistics,'order_count'=>$order_count]);
    }
}