<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\merchant_admin;

use app\api\controller\merchant_admin\MerchantBase;
use think\Db;
use app\common\model\bbfxshop\User;

class Withdrawal extends MerchantBase
{
    protected $noNeedLogin = [];
    protected $noMerchantNeedRight = [];
    protected $noNeedRight = ['*'];

    public function getList(){
        $params = $this->param();
        
        $list = Db::name("bbfx_withdrawal_log")->where(["uniacid"=>UNIACID,"user_id"=>$this->mid,'withdrawal_type'=>7])->select();
        foreach ($list as &$val){
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        }
        unset($val);
        
        __success("success",array("list"=>$list,"title"=>"商户提现"));
    }
    
    public function submit(){
        $params = $this->param();
        $user = $this->user;
        $merchant = $this->merchant;
        User::checkStatus($user);
        User::checkTxdateLimit();
        
        $config = $this->model->getSet();
        
        $money = round($params['money'],2);
        
        if($_W['base']['is_pay_password'] == 1){
	        $pay_password = Db::name("bbfx_user")->where("id",$this->user['id'])->value("pay_password");
		    if($pay_password !== md5($params['pay_password'])){
		        __error("支付密码错误");
		    }
	    }
        
        if($money <= 0 || empty($money)){
            __error("请输入大于0的金额");
        }
        
        $type = intval($params['type']);
        if(!in_array($type,[2,3,4,5])){
            __error("请选择提现方式");
        }
        
        
        $withdrawal_info = [];
        if($type == 3){
            if(!$params['realname']){
                __error("请填写姓名");
            }
            if(!$params['alipay']){
                __error("请填写支付宝账号");
            }
            if($params['alipay'] != $params['realipay']){
                __error("两次输入的账号不一致");
            }
            
            $data = array(
                "realname"=>$params['realname'],
                "alipay"=>$params['alipay']
            );
            
            $withdrawal_info['zfb_realname'] = $params['realname'];
            $withdrawal_info['zfb'] = $params['alipay'];
        }
        else if($type == 4){
            if(!$params['realname']){
                __error("请填写姓名");
            }
            if(!$params['bankname']){
                __error("请选择银行");
            }
            if(!$params['bankcard']){
                __error("请填写银行卡号");
            }
            if($params['bankcard'] != $params['rebankcard']){
                __error("两次输入的卡号不一致");
            }
            
            $data = array(
                "realname"=>$params['realname'],
                "bankname"=>$params['bankname'],
                "bankcard"=>$params['bankcard']
            );
            
            $withdrawal_info['bank_realname'] = $params['realname'];
            $withdrawal_info['bankname'] = $params['bankname'];
            $withdrawal_info['bankcard'] = $params['bankcard'];
        }
        else if($type == 5){
            if(!$params['skqrcode']){
                __error("请上传收款码");
            }
            
            $data = array(
                "skqrcode"=>$params['skqrcode'],
            );
            
        }
        else if($type == 2){
            if($money >= 2000 &&  $type == 2){
                if(!$params['realname']){
                    __error("请填写姓名");
                }
                $data = array(
                    "realname"=>$params['realname']
                );
                $withdrawal_info['realname'] = $params['realname'];
            }
        }
        else{
            __error("提现方式错误");
        }
        
        
        $data['type'] = $type;
        
        $unit = "元";
        $withdrawal_limit = max(1,floatval($config['withdrawal']['min']));
        $max_withdrawal = floatval($config['withdrawal']['max']);
        
        $service_charge_rate = floatval($config['withdrawal']['service_charge']);
        $service_charge = $money * ($service_charge_rate / 100);
        
        $realmoney = $money - $service_charge;
        
        $integer = intval($config['withdrawal']['integer_multiple']);
        
        
        if($money < $withdrawal_limit){
            __error("最低提现".$withdrawal_limit.$unit);
        }
        
        if($max_withdrawal > 0 && $money > $max_withdrawal){
            __error("最高提现".$max_withdrawal.$unit);
        }
        
        if($integer > 0){
            if($money % $integer != 0){
                __error("请输入{$integer}的倍数提现");
            }
        }
        
        $currency = floatval($merchant['balance']);
        
        if($currency < $money){
            __error("余额不足");
        }
        
        
        $data['withdrawal_type'] = 7;
        $data['service_charge'] = $service_charge;
        $data['realmoney'] = $realmoney;
        $data['money'] = $money;
        $data['user_id'] = $merchant['id']; 
        $data['uniacid'] = UNIACID;
        $data['withdrawal_no'] = date('YmdHis').random(8,true);  
        $data['createtime'] = time();
        // __error("请选择提现方式666");
        try {
            Db::startTrans();
            
            $id = Db::name("bbfx_withdrawal_log")->insertGetId($data);
            if(empty($id)){
                throw new \Exception("提现失败1");
            }
            
            $data['id'] = $id;
            
            $res = $this->model->setUserMoney($merchant['id'],0-$money,1,2,"余额提现",$data);
            
            if($res['code'] != 1){
                throw new \Exception($res['message']);
            }
            
            
            Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
        	$msg = $e->getMessage();
        	__error($msg);
        }
        
        $log = Db::name("bbfx_withdrawal_log")->where(['id'=>$id])->find();
        \app\common\model\bbfxshop\Sms::sendWithdrawalNotice($log);
        
        __success("提交成功，请等待审核");
        
    }
    
    public function confirm(){
        $withdrawal_no = $this->param("withdrawal_no/s");
        $log = Db::name("bbfx_withdrawal_log")->where(["uniacid"=>UNIACID,"user_id"=>$this->merchant['id'],'withdrawal_no'=>$withdrawal_no])->find();
        if(empty($log)){
            __error("未查询到提现记录");
        }
        if($log['type'] != 2){
            __error("提现类型错误");
        }
        if($log['status'] != 1){
            __error("提现未审核通过");
        }
        
        if($log['is_confirm'] == -1){
            __error("不是新版商家转账到零钱");
        }
        if($log['is_confirm'] == 1){
            __error("已确认收款");
        }
        
        $user = User::getInfo($this->merchant['user_id']);
        
        $result = \app\common\model\bbfxshop\Wxpay::queryNewTransfer($log['out_batch_no'],$user['platform']);
        if($result['code'] != 1){
            __result($result);
        }
        
        $state = $result['data']['state'];
        if($state == 'SUCCESS'){
            Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update(['is_confirm'=>1,'confirmtime'=>time()]);
            
            __success("操作成功");
        }
        
        __error("您还未确认收款成功");
    }
    
    public function queryWaitInfo(){
        $withdrawal_no = $this->param("withdrawal_no/s");
        $log = Db::name("bbfx_withdrawal_log")->where(["uniacid"=>UNIACID,"user_id"=>$this->merchant['id'],'withdrawal_no'=>$withdrawal_no])->find();
        if(empty($log)){
            __error("未查询到提现记录");
        }
        
        // __error("未查询到提现记录");
        if($log['type'] != 2){
            __error(-2,"提现类型错误");
        }
        if($log['status'] != 1){
            __error(-2,"提现未审核通过");
        }
        if($log['is_confirm'] == 1){
            __error(-2,"已确认收款");
        }
        $user = User::getInfo($this->merchant['user_id']);
        $result = \app\common\model\bbfxshop\Wxpay::queryNewTransfer($log['out_batch_no'],$user['platform']);
        if($result['code'] != 1){
            __result($result);
        }
        
        $state = $result['data']['state'];
        
        if($state == 'SUCCESS'){
            Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update(['is_confirm'=>1,'confirmtime'=>time()]);
            __error(-2,"您已收款成功");
        }
        
        
        if($state != 'WAIT_USER_CONFIRM' && $state != 'TRANSFERING'){
            
            $out_batch_no = date("YmdHis").random(8,true);
            Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update(['out_batch_no'=>$out_batch_no]);
            $log['out_batch_no'] = $out_batch_no;
            $transfer_remark = "余额提现";
            $remarks = ['1'=>'余额提现','2'=>'佣金提现','3'=>'积分提现','5'=>'红包提现','6'=>'预存款提现','7'=>'商户提现'];
            $transfer_remark = $remarks[$log['withdrawal_type']];
            
            $res = \app\common\model\bbfxshop\Wxpay::newTransfer($user['openid'],$log['realmoney'],$out_batch_no,$log['realname'],$transfer_remark,$user['platform']);
            if($res['code'] != 1){
                __result($res);
            }
            
            $data = [
                'batch_id'=>$res['data']['transfer_bill_no'],
                'package_info'=>''
            ];
            if(!empty($res['data']['package_info'])){
                $data['package_info'] = $res['data']['package_info'];
                $log['package_info'] = $res['data']['package_info'];
            }
            
            Db::name("bbfx_withdrawal_log")->where(['id'=>$log['id']])->update($data);
            
        }
        
        
        $set = \app\common\model\bbfxshop\Wxpay::getSet($user['platform']);
        
        $result = [
            "mchId"=>$set['mchid'],
            "appId"=>$set['appid'],
            "package"=>$log['package_info'],
        ];
        
        __success("操作成功",$result);
    }
}