<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\returns;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Index extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\ReturnMode;
    }
    
    public function getList(){
        $params = $this->param();
        
        
        $type = intval($params['type']);
        $where = ['uniacid'=>UNIACID,'user_id'=>$this->user['id']];
        if($type){
            $where['type'] = $type;
        }
        
        $list = Db::name("bbfx_return_item")->where($where)->order("createtime desc")->select();
        if(empty($list)){
            $list = [];
        }
        
        foreach ($list as $key => &$val){
            $info = iunserializer($val['info']);
            $goods = iunserializer($info['goods_info']);
            $goods['thumb'] = cdnurl($goods['thumb']);
            $val['goods'] = $goods;
            $val['info'] = $info;
            $order_no = Db::name("bbfx_order")->where(['id'=>$val['order_id']])->value("order_no");
            $val['order_no'] = $order_no;
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['statusText'] = "返还中";
            if($val['status'] == 1){
    	        $val['statusText'] = "已完成";
    	        $total_ok = $val['total'];
    	    }
    	    else{
                $total_ok = Db::name("bbfx_return_log")->where(['uniacid'=>UNIACID,'user_id'=>$val['user_id'],'pid'=>$val['id']])->sum('money');
    	        $total_ok = round($total_ok,2);
    	    }
    	    $val['total_ok'] = $total_ok;
        }
        unset($val);
        
        __success("操作成功",$list);
    }
    
    public function getLog(){
        $params = $this->param();
        
        
        $pid = intval($params['pid']);
        
        $list = Db::name("bbfx_return_log")->where(['uniacid'=>UNIACID,'pid'=>$pid,'user_id'=>$this->user['id']])->order("id desc")->select();
        if(empty($list)){
            $list = [];
        }
        
        foreach ($list as $key => &$val){
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        }
        unset($val);
        
        __success("操作成功",$list);
    }
}