<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\store\scoreshop;

use app\api\controller\store\StoreBase;
use think\Db;
use app\common\model\bbfxshop\Order as OrderModel;
use app\common\model\bbfxshop\Scoreshop;


class Order extends StoreBase
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Store;
    }
    
    public function getHexiaoRecordList(){
        $page = $this->param('page/d');
        $store_id = $this->param('store_id/d');
        $limit = 20;
        $store = $this->store;
        $where = ['uniacid'=>UNIACID,'store_id'=>$store['id'],'status'=>3,'order_type'=>['in',[2,4]],'is_hexiao'=>1];
        $identity = $this->param("identity/d");
        if($identity == 1){
            $ids = array_column($this->dealer_store, 'id');
            $ids[] = -1;
            $where['store_id'] = ['in',$ids];
            if($store_id > 0){
                $where['store_id'] = $store_id;
            }
        }
        else{
            $where['store_id'] = $this->store['id'];
        }
        
        
        $list = Db::name("bbfx_scoreshop_order")->where($where)->order('id desc')->limit(($page-1)*$limit,$limit)->select();
        if(!empty($list)){
            foreach($list as $key => &$val){
                
                $val['paytypeText'] = Scoreshop::getOrderPaytype($val['paytype']);
                $val['statusText'] = Scoreshop::getOrderStatus($val);
                $val['hexiao_store'] = iunserializer($val['hexiao_store']);
                $val['hexiao_store']['logo'] = cdnurl($val['hexiao_store']['logo']);
                
                $val['goods_info'] = iunserializer($val['goods_info']);
                $order_goods = Db::name("bbfx_scoreshop_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$val['id']])->select();
                $total = 0;
                foreach($order_goods as $k => &$v){
                    $goods_info = iunserializer($v['goods_info']);
                    $goods_info['thumb'] = cdnurl($goods_info['thumb']);
                    $v['goods'] = $goods_info;
                    if($goods_info['type'] == 1 && $val['status'] >= 1){
                        $serial_number = Db::name("bbfx_scoreshop_serial_number")->where(['uniacid'=>UNIACID,'pid'=>$v['id']])->find();
                        if(!empty($serial_number)){
                            $v['serial_number'] = $serial_number;
                        }
                        else{
                            $v['serial_number'] = "";
                        }
                    }
                    $total += $v['total'];
                }
                unset($v);
                $val['order_goods'] = $order_goods;
                $val['pay_time'] = date("Y-m-d H:i:s",$val['pay_time']);
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
                $val['hexiao_time'] = date("Y-m-d H:i:s",$val['hexiao_time']);
                $val['express'] = iunserializer($val['express']);
                $val['hexiao_wxacode'] = cdnurl($val['hexiao_wxacode']);
                $val['hexiao_qrcode'] = cdnurl($val['hexiao_qrcode']);
                
                $val['total'] = intval($total);
                
                $user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'id'=>$val['user_id']])->field("id,nickname,avatar")->find();
                if(!empty($user)){
                    $user['avatar'] = cdnurl($user['avatar']);
                    $val['user'] = $user;
                }
            }
            unset($val);
            __success("操作成功",$list);
        }
        else{
            __error($page==1?"未查询到订单":"没有更多了",$where);
        }
    }
    
    public function getList(){
        $page = $this->param('page/d');
        $limit = 20;
        $keyword = $this->param("keyword/s");
        $status = intval($this->param('status/d'));
        $where = ['uniacid'=>UNIACID];
        if($status != -1){
            if($status == 4){
                $where['status'] = ['>',0];
                $where['refund_status'] = ['>=',0]; 
            }
            else{
                $where['status'] = $status;
            }
        }
        
        $identity = $this->param("identity/d");
        if($identity == 1){
            $store_id = $this->param('store_id/d');
            $ids = array_column($this->dealer_store, 'id');
            $ids[] = -1;
            $where['store_id'] = ['in',$ids];
            if($store_id > 0){
                $where['store_id'] = $store_id;
            }
            // print_r($where);die;
        }
        else{
            $where['store_id'] = $this->store['id'];
        }
        
        $list = Db::name("bbfx_scoreshop_order")->where($where)->where(function($query) use($keyword){
            if(!empty($keyword)){
                $whereOr = [];
            // 	$whereOr['order_no'] = $keyword;
            	$whereOr['goods_info'] = ['like','%'.$keyword.'%'];
            	if(intval($keyword) > 0){
            	   // $whereOr['user_id'] = intval($keyword);
            	}
            	$query->whereOr($whereOr);
            }
        })->order('id desc')->limit(($page-1)*$limit,$limit)->select();
        if(!empty($list)){
            foreach($list as $key => &$val){
                
                $val['paytypeText'] = Scoreshop::getOrderPaytype($val['paytype']);
                $val['statusText'] = Scoreshop::getOrderStatus($val);
                $val['hexiao_store'] = iunserializer($val['hexiao_store']);
                $val['hexiao_store']['logo'] = cdnurl($val['hexiao_store']['logo']);
                
                $val['goods_info'] = iunserializer($val['goods_info']);
                $order_goods = Db::name("bbfx_scoreshop_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$val['id']])->select();
                $total = 0;
                foreach($order_goods as $k => &$v){
                    $goods_info = iunserializer($v['goods_info']);
                    $goods_info['thumb'] = cdnurl($goods_info['thumb']);
                    $v['goods'] = $goods_info;
                    if($goods_info['type'] == 1 && $val['status'] >= 1){
                        $serial_number = Db::name("bbfx_scoreshop_serial_number")->where(['uniacid'=>UNIACID,'pid'=>$v['id']])->find();
                        if(!empty($serial_number)){
                            $v['serial_number'] = $serial_number;
                        }
                        else{
                            $v['serial_number'] = "";
                        }
                    }
                    $total += $v['total'];
                }
                unset($v);
                $val['order_goods'] = $order_goods;
                $val['pay_time'] = date("Y-m-d H:i:s",$val['pay_time']);
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
                $val['express'] = iunserializer($val['express']);
                $val['hexiao_wxacode'] = cdnurl($val['hexiao_wxacode']);
                $val['hexiao_qrcode'] = cdnurl($val['hexiao_qrcode']);
                
                $val['total'] = intval($total);
                
                $user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'id'=>$val['user_id']])->field("id,nickname,avatar")->find();
                if(!empty($user)){
                    $user['avatar'] = cdnurl($user['avatar']);
                    $val['user'] = $user;
                }
            }
            unset($val);
            __success("操作成功",$list);
        }
        else{
            __error($page==1?"未查询到订单":"没有更多了",$where);
        }
    }
    
    public function hexiao(){
        $id = $this->param('id/d');
        
        if(empty($this->store)){
            __error("无权限核销");
        }
        
        $result = Scoreshop::hexiao($id,$this->user['id'],$this->store);
        if($result['code'] != 1){
            __error($result['message']);
        }
        __success($result['message']);
    }

    public function detail(){
        $id = $this->param('id/d');
        
        $where = ['uniacid'=>UNIACID,'id'=>$id];
        
        $identity = $this->param("identity/d");
        if($identity == 1){
            $store_id = $this->param('store_id/d');
            $ids = array_column($this->dealer_store, 'id');
            $ids[] = -1;
            $where['store_id'] = ['in',$ids];
            if($store_id > 0){
                $where['store_id'] = $store_id;
            }
        }
        else{
            $where['store_id'] = $this->store['id'];
        }
        
        $order = Db::name("bbfx_scoreshop_order")->where($where)->find();
        if(empty($order)){
            __error("订单不存在",$where);
        }
        
        $xia_user = Db::name("bbfx_user")->where("id",$order['user_id'])->field("id,nickname,avatar,level")->find();
        if(!empty($xia_user)){
            $xia_user['avatar'] = cdnurl($xia_user['avatar']);
            if($xia_user['is_distributor'] == 1 && $xia_user['distributor_status'] == 1){
                $leveldata = \app\common\model\bbfxshop\Fenxiao::getLevel($xia_user['level']);
                $xia_user['levelname'] = $leveldata['title'];
            }
            else{
                $xia_user['levelname'] = "普通用户";
            }
            $order['xia_user'] = $xia_user;
        }
        
        if(($order['order_type'] == 2 || $order['order_type'] == 4) && $order['is_hexiao'] == 1 && $order['status'] == 3){
            $hexiao_user = Db::name("bbfx_user")->where("id",$order['hexiao_uid'])->field("id,nickname,avatar,level")->find();
            if(!empty($hexiao_user)){
                $hexiao_user['avatar'] = cdnurl($hexiao_user['avatar']);
                $order['hexiao_user'] = $hexiao_user;
            }
        }
        
        if($order['order_type'] == 2){
            $order['express'] = iunserializer($order['express']);
        }
        
        $goods_info = iunserializer($order['goods_info']);
        foreach ($goods_info as $key => &$val){
            $val['thumb'] = cdnurl($val['thumb']);
        }
        unset($val);
        $order['goods_info'] = $goods_info;
        $order['createtime'] = date("Y-m-d H:i:s",$order['createtime']);
        $order['pay_time'] = date("Y-m-d H:i:s",$order['pay_time']);
        $order['hexiao_time'] = date("Y-m-d H:i:s",$order['hexiao_time']);
        
        $order_goods = Db::name("bbfx_scoreshop_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$order['id']])->select();
                
        foreach($order_goods as $k => &$v){
            $goods_info = iunserializer($v['goods_info']);
            $goods_info['thumb'] = cdnurl($goods_info['thumb']);
            $v['goods'] = $goods_info;
            if($goods_info['type'] == 1 && $order['status'] >= 1){
                $serial_number = Db::name("bbfx_scoreshop_serial_number")->where(['uniacid'=>UNIACID,'pid'=>$v['id']])->find();
                if(!empty($serial_number)){
                    $v['serial_number'] = $serial_number;
                }
                else{
                    $v['serial_number'] = "";
                }
            }
        }
        unset($v);
        $order['order_goods'] = $order_goods;
        
        $paytypes = ['1'=>'微信支付','2'=>'余额支付'];
                
        $order['paytypeText'] = Scoreshop::getOrderPaytype($order['paytype']);
        
        $order['statusText'] = Scoreshop::getOrderStatus($order);
        
        $order['hexiao_store'] = iunserializer($order['hexiao_store']);
        
        __success("操作成功",$order);
    }
}