<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\store_client;

use app\api\controller\Base;
use think\Db;


class Reservation extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Store;
    }

    public function submit(){
        $params = $this->param(['mobile/s','reservation_time/s','notes/s','store_id/d']);
        $reservation_time = strtotime($params['reservation_time']);
        
        if($reservation_time < time()){
            __error("到店时间必须大于当前时间");
        }
        if(empty($params['mobile'])){
            __error("请输入手机号");
        }
        
        $store = $this->model->getInfo($params['store_id']);
        if(empty($store)){
            __error("门店不存在");
        }
        
        $stime = strtotime(date("Y-m-d 00:00:00",$reservation_time));
        $etime = strtotime(date("Y-m-d 23:59:59",$reservation_time));
        
        $reservation = Db::name("bbfx_store_reservation")->where(['uniacid'=>UNIACID,'store_id'=>$store['id'],'reservation_time'=>['>',$stime]])->where(['reservation_time'=>['<',$etime]])->find();
        if(!empty($reservation)){
            __error("当日已预约");
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "user_id"=>$this->user['id'],
            "store_id"=>$params['store_id'],
            "mobile"=>$params['mobile'],
            "notes"=>$params['notes'],
            "reservation_time"=>$reservation_time,
            "createtime"=>time(),
        );
        
        $res = Db::name("bbfx_store_reservation")->insert($data);
        if($res){
            __success("预约成功");
        }
        else{
            __error("预约失败");
        }
    }
    
    public function getList(){
        $page = $this->param("page/d");
        $page = max(1,$page);
        $limit = 10;
        
        $list = Db::name("bbfx_store_reservation")->alias("a")->join("bbfx_store b","a.store_id=b.id","LEFT")->where(['a.uniacid'=>UNIACID,'a.user_id'=>$this->user['id'],'b'])->order("a.createtime desc")->limit(($page-1)*$limit,$page)->select();
        $total = Db::name("bbfx_store_reservation")->alias("a")->join("bbfx_store b","a.store_id=b.id","LEFT")->where(['a.uniacid'=>UNIACID,'a.user_id'=>$this->user['id'],'b'])->count();
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
}