<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\transfer_account;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\ReturnMode;


class Index extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\TransferAccount;
    }
    
    public function transfer(){
        global $_W;
        $params = $this->param();
        
        $to_user_id = intval($params['to_user_id']);
        $type = intval($params['type']);
        $money = floatval($params['money']);
        
        $to_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'id'=>$to_user_id])->count();
        if(empty($to_user)){
            __error("查询用户失败");
        }
        
        if($_W['base']['is_pay_password'] == 1){
	        $pay_password = Db::name("bbfx_user")->where("id",$this->user['id'])->value("pay_password");
		    if($pay_password !== md5($params['pay_password'])){
		        __error("支付密码错误");
		    }
	    }
        
        $res = $this->model->transfer($type,$this->user['id'],$to_user_id,$money);
        
        if($res['code'] !== 1){
            __error($res['message']);
        }
        
        __success("转账成功");
    }
    
    public function getRecords(){
        $params = $this->param();
        $type = intval($params['type']);
        $list = [];
        $list[0] = Db::name("bbfx_transfer_account_log")->where(['uniacid'=>UNIACID,'type'=>$type,'from_user_id'=>$this->user['id']])->order(['createtime desc','id desc'])->select();
        if(empty($list[0])){
            $list[0] = [];
        }
        
        $list[1] = Db::name("bbfx_transfer_account_log")->where(['uniacid'=>UNIACID,'type'=>$type,'to_user_id'=>$this->user['id']])->order(['createtime desc','id desc'])->select();
        if(empty($list[1])){
            $list[1] = [];
        }
        
        foreach ($list[0] as $key => &$val){
            $to_user = Db::name("bbfx_user")->where(['id'=>$val['to_user_id']])->find();
            $to_user['avatar'] = cdnurl($to_user['avatar']);
            $val['avatar'] = $to_user['avatar'];
            $val['nickname'] = $to_user['nickname'];
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['uid'] = $val['to_user_id'];
        }
        unset($val);
        
        foreach ($list[1] as $key => &$val){
            $from_user = Db::name("bbfx_user")->where(['id'=>$val['from_user_id']])->find();
            $from_user['avatar'] = cdnurl($from_user['avatar']);
            $val['avatar'] = $from_user['avatar'];
            $val['nickname'] = $from_user['nickname'];
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['uid'] = $val['from_user_id'];
        }
        unset($val);
        
        __success("操作成功",$list);
    }
    
    public function queryUser(){
        $params = $this->param();
        $to_user_id = intval($params['to_user_id']);
        $to_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'id'=>$to_user_id])->find();
        if(empty($to_user)){
            __error("用户不存在");
        }
        $to_user['avatar'] = cdnurl($to_user['avatar']);
        
        __success("操作成功",$to_user);
    }
}