<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;
use think\Db;
class Qwen{

    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }

        return $base['qwen'];
    }

    // 通义千问（流式输出）
    public function askAuestion($user_id,$ckey,$content){
        $config = self::getSet();

        $error_msg = "";
        if(empty($content)){
            $error_msg = "内容不能为空";
            // return __json(0,"内容不能为空");
        }

        $user = User::getInfo($user_id);
        if(empty($user)){
            $error_msg = "用户信息错误";
            // return __json(0,'用户信息错误');
        }
        if(!empty($config['levels'])){
            if(!in_array($user['level'],$config['levels']) || $user['is_distributor'] != 1 || $user['distributor_status'] != 1){
                $error_msg = "您无权限是用该功能！";
                // return __json(0,'您无权限是用该功能！');
            }
        }

        header('Content-Type: text/event-stream'); // 以事件流的形式告知浏览器进行显示
        header('Cache-Control: no-cache'); // 告知浏览器不进行缓存
        header('X-Accel-Buffering: no'); //关闭加速缓冲

        // $error_msg = '您无权限是用该功能！';
        if(!empty($error_msg)){
            $json = toJsonen(['choices'=>[['finish_reason'=>'stop','delta'=>['content'=>$error_msg]]]]);
            echo "data: ".$json."\n\n";
            ob_flush();
            flush();
            sleep(1);
            echo "data: [DONE]\n\n";
            ob_flush();
            flush();
            die;
        }

        

        $url="https://dashscope.aliyuncs.com/compatible-mode/v1/chat/completions";
        // 模型列表：https://help.aliyun.com/zh/model-studio/getting-started/models
        $json = [
            "model" => $config['model'],
            "messages" => [
                [
                    "role" => "system",
                    "content" => ""
                ], 
                [
                    "role" => "user",
                    "content" => ""
                ]
            ],
            "stream"=>true
        ];
        $messages = [];
        $chat_list = Db::name("bbfx_qwen_chat")->where(['uniacid'=>UNIACID,'ckey'=>$ckey,'user_id'=>$user_id])->order("id asc")->select();
        if(!empty($chat_list)){
            foreach ($chat_list as $k=>$v){
                $messages[] = ['role'=>$v['role'],'content'=>$v['content']];
            }
        }
        else{
            if(empty($ckey)){
                $ckey = \fast\Random::alnum(10);
            }
        }

        $messages[] = ['role'=>'user','content'=>$content];

        $json['messages'] = $messages;

        $header = [
            'Authorization: Bearer Bearer '.$config['apikey'],
            'Content-Type: application/json'
        ];

        $data = [
            'uniacid'=>UNIACID,
            'user_id'=> $user_id,
            'ckey'=>$ckey,
            'content'=>$content,
            'role'=>'user',
            'createtime'=>time()
        ];
        
        $pid = Db::name("bbfx_qwen_chat")->insertGetId($data);

        $res = $this->curlStreamRequest($url,json_encode($json),$header, function($result) use($user_id,$ckey,$pid) {
            // 将数据写入输出缓冲区或直接发送给客户端-例如，使用 echo 或 SSE 发送数据

            $chat = Db::name("bbfx_qwen_chat")->where(['uniacid'=>UNIACID,'pid'=>$pid,'role'=>'system','ckey'=>$ckey,'user_id'=> $user_id])->order("id desc")->find();
            
            $odata = $result;
            if(!empty($chat) && $chat['status'] == 1){
                die;
            }
            else{
                echo $result;
                $list = [];
                if(substr_count($result,'data: ') > 1){
                    $list = explode('data: ', $result);
                    foreach($list as $k => &$val){
                        $val = json_decode($val,true);
                    }
                    unset($val);
                }
                else{
                    $result = json_decode(str_replace('data: ','', $result),true);
                    $list[] = $result;
                }

                foreach($list as $k => $result){
                    if(!empty($result['choices'])){
                        foreach($result['choices'] as $key => $val){
                            
                            if(!empty($chat)){
                                $cid = $chat["id"];
                                Db::name("bbfx_qwen_chat")->where(['id'=>$cid])->update(['content'=>$chat['content'].$val['delta']['content']]);
                            }
                            else{
                                $chat = [
                                    'uniacid'=>UNIACID,
                                    'user_id'=> $user_id,
                                    'ckey'=>$ckey,
                                    'pid'=>$pid,
                                    'content'=>$val['delta']['content'],
                                    'role'=>'system',
                                    'createtime'=>time()
                                ];
                                $cid = Db::name("bbfx_qwen_chat")->insertGetId($chat);
                                $chat['id'] = $cid;
                            }
                            
                        }
                    }
                }
                if(strstr($odata, '[DONE]')){
                    Db::name("bbfx_qwen_chat")->where(['uniacid'=>UNIACID,'ckey'=>$ckey,'user_id'=> $user_id,'status'=>0])->update(['status'=>1,'ctime'=>time()]);
                }
            }
            
            

            //刷新输出缓冲区---把数据输出给浏览器
            ob_flush();
            flush();
        });

        if($res != 1){
            Db::name("bbfx_qwen_chat")->where(["id"=> $pid])->delete();
            Db::name("bbfx_qwen_chat")->where(["pid"=> $pid])->delete();
        }

        return __json(1,"操作成功",['data'=>$res,'ckey'=>$ckey]);
    }

    /**
     * 流式请求--通过 cURL 发起流式请求并处理响应
     *
     * @param string $url 请求的 URL
     * @param array $headers 请求头数组
     * @param array|string|null $postData POST 数据
     * @param callable $callback 处理响应数据的回调函数
     * @throws Exception 如果回调函数不是有效的 Callable
     */
    private function curlStreamRequest(string $url,$postData = null, array $headers = [],  callable $callback) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, false); // 不将响应保存为字符串，直接处理
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 注意：在生产环境中应启用 SSL 验证
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); // 注意：同上
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_POST, is_array($postData) || !empty($postData));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_WRITEFUNCTION, function ($ch, $data) use ($callback) {
            // 调用回调函数处理数据
            $callback($data);
            return strlen($data); // 返回接收到的数据长度
        });

        // 执行请求并获取响应
        $response = curl_exec($ch);

        // 检查是否有错误发生
        if (curl_errno($ch)) {
            throw new \Exception(curl_error($ch));
        }

        // 关闭 cURL 句柄
        curl_close($ch);

        if(is_string($response) && !empty($response)){
            $response1 = json_decode($response,true);
            if(!empty($response1)){
                $response = $response1;
            }
        }

        return $response;
    }
}