<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use app\common\model\bbfxshop\User;


class TransferAccount extends Model
{
    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        return $base['transfer_account'];
    }

    public function isCrosslineUser($user_id,$to_user_id,$uids = []){
        $sup_uid = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'id'=>$user_id])->value("sup_uid");
        if(empty($sup_uid)){
            return false;
        }

        if($sup_uid == $to_user_id){
            return true;
        }

        if(in_array($sup_uid,$uids)){
            return false;
        }

        $uids[] = $sup_uid;

        return $this->isCrosslineUser($sup_uid,$to_user_id,$uids);
    }
     
    public function transfer($type,$from_user_id,$to_user_id,$money){
        $config = self::getSet();
        $money = floatval($money);
        $money = round($money,2);
        if(!in_array($type,[1,2])){
            return __json(0,"转账类型错误");
        }
        
        if($config['status'] != 1){
            return __json(0,"资金转账未开启");
        }
        if($type == 1 && $config['balance_status'] != 1){
            return __json(0,"余额转账未开启");
        }
        if($type == 2 && $config['score_status'] != 1){
            return __json(0,"积分转账未开启");
        }
        
        if($money <= 0){
            return __json(0,$type==1?"转账金额必须大于0":"转账积分必须大于0");
        }
        
        $from_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'id'=>$from_user_id])->find();
        $to_user = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'id'=>$to_user_id])->find();
        if(empty($from_user)){
            return __json(0,"转账用户信息错误");
        }
        if(empty($to_user)){
            return __json(0,"接收用户信息错误");
        }
        
        if($type == 1){
            if($money > floatval($from_user['balance'])){
                return __json(0,"余额不足");
            }
            $service_recharge = (floatval($config['service_charges1']) / 100) * $money;
            $service_recharge = round($service_recharge,2);
        }
        else if($type == 2){
            if($money > floatval($from_user['score'])){
                return __json(0,"积分不足");
            }
            $service_recharge = (floatval($config['service_charges2']) / 100) * $money;
            $service_recharge = round($service_recharge,0);
        }
        else{
            return __json(0,"操作失败");
        }
        
        $realmoney = $money;
        $money += $service_recharge;
        
        if($realmoney <= 0){
            return __json(0,"配置错误");
        }

        if($config['is_crossline'] == 1){

            if(!strstr($to_user['sup_path'], '-'.$from_user['id'].'-')){
                $isCrosslineUser = $this->isCrosslineUser($from_user['id'], $to_user['id']);
                if(!$isCrosslineUser){
                    return __json(0,'不是同一线上用户不能转账');
                }
            }
        }
        
        try {
        	Db::startTrans();
        	
        	$remarks = "余额转账";
        	if($type == 2){
        	    $remarks = "积分转账";
        	}
        	$data = array(
        	    "uniacid"=>UNIACID,
        	    "from_user_id"=>$from_user['id'],
        	    "to_user_id"=>$to_user['id'],
        	    "money"=>$money,
        	    "service_recharge"=>$service_recharge,
        	    "realmoney"=>$realmoney,
        	    "type"=>$type,
        	    "createtime"=>time()
        	);
        	
        	$id = Db::name("bbfx_transfer_account_log")->insertGetId($data);
        	if(empty($id)){
        	    throw new \Exception("新增记录失败");
        	}
        	
        	$data['id'] = $id;
        	$res = User::setUserMoney($from_user['id'],0-$money,$type,12,$remarks,$data);
        	if(empty($res)){
        	    throw new \Exception("转账失败");
        	}
        	$res = User::setUserMoney($to_user['id'],$realmoney,$type,12,$remarks,$data);
        	if(empty($res)){
        	    throw new \Exception("转账失败");
        	}
        	
        	$result = __json(1,"转账成功");
        	Db::commit();
        } 
        catch (Exception $e) {
        	Db::rollback();
        	$msg = $e->getMessage();
        	
        	$result = __json(0,$msg);
        }
        
        return $result;
    }
}